<?php 
namespace WCQT\classes\admin;

class EmailTextsPage
{
	public function __construct()
	{
		
	}
	//rplc: woocommerce-quote, wcqt, WCQT
	public function render_page()
	{
		global $wcqt_order_model, $wcqt_option_model, $wcqt_wpml_model;
		
		//Assets
		wp_enqueue_style( 'wcqt-admin-common', WCQT_PLUGIN_PATH.'/css/admin/common.css');
		wp_enqueue_style( 'wcqt-admin-email-settings', WCQT_PLUGIN_PATH.'/css/admin/email-settings-page.css');
		
		if(isset($_POST['submit']) && wp_verify_nonce( wcqt_get_value_if_set($_POST, 'wcqt_security', ""), 'wcqt_admin_email_texts_page' ))
		{
			$wcqt_option_model->save_email_texts($_POST['wcqt_email_texts']);
		}
		$security = wp_create_nonce('wcqt_admin_email_texts_page');
		$langs =  $wcqt_wpml_model->get_langauges_list();
		$texts = $wcqt_option_model->get_email_texts(); 
		$def_lang = $wcqt_wpml_model->get_default_language_code();
		?>
		<div class="wrap white-box">
				<form action="" method="post" >
					<input type="hidden" name="wcqt_security" value="<?php echo $security; ?>"/>
					<h2 class="wcqt_section_title wcqt_no_margin_top"><?php esc_html_e('Customer - New quote submission notification', 'woocommerce-quote');?></h2>
						
					<h3><?php esc_html_e('Heading', 'woocommerce-quote');?></h3> 
					<label><?php esc_html_e('You can use optionally use the [order_id] shortcode. ', 'woocommerce-quote');?></label>
					<?php foreach($langs as $lang_data): ?>
					<div class="wcqt_option_group">
						<div class="wcqt_editor_container">
							<?php $content = wcqt_get_value_if_set($texts , array('customer', 'new-quote', 'heading', $lang_data['language_code']), "");?>
							<input type="text" class="wcqt_subject" value="<?php esc_attr_e($content);?>" name="wcqt_email_texts[customer][new-quote][heading][<?php echo $lang_data['language_code']; ?>]"></input>
						</div>
					</div>	
					<?php endforeach; ?>
					<h3><?php esc_html_e('Subject', 'woocommerce-quote');?></h3> 
					<label><?php esc_html_e('You can use optionally use the [order_id] shortcode. ', 'woocommerce-quote');?></label>
					
					<?php foreach($langs as $lang_data): ?>
								<div class="wcqt_option_group">
									<?php if($lang_data['country_flag_url'] != "none"): ?>
										<img src=<?php esc_attr_e($lang_data['country_flag_url']); ?> /><label class="wcqt_label"> <?php echo ucwords($lang_data['language_code']); ?></label>
									<?php endif; 
									$content = wcqt_get_value_if_set($texts , array('customer', 'new-quote', 'subject', $lang_data['language_code']), "");
									?>
									<input type="text" class="wcqt_subject" value="<?php esc_attr_e($content);?>" name="wcqt_email_texts[customer][new-quote][subject][<?php echo $lang_data['language_code']; ?>]"></input>
								</div>
						<?php endforeach; ?>
					
					
					<h3><a id="messages"></a><?php esc_html_e('Message', 'woocommerce-quote');?></h3>
					<div class="wcqt_option_group">
						<div class="wcqt_shortcode_container">
							<label><?php esc_html_e('SHORTCODES', 'woocommerce-quote');?></label>
							<p><?php esc_html_e('You can use the following shortcodes:', 'woocommerce-quote');?></p>
							<label><?php esc_html_e('Quote data', 'woocommerce-quote');?></label>
							[order_id], [order_total], [order_date], [order_url]
							<br><br>
							<label><?php esc_html_e('Billing data', 'woocommerce-quote');?></label>
							[billing_first_name], [billing_last_name], [billing_email], [billing_company], [billing_company], [billing_phone], [billing_country], [billing_state], [billing_city], [billing_post_code], [billing_address_1], [billing_address_2], [formatted_billing_address]
							<br><br>
							<label><?php esc_html_e('Shipping data', 'woocommerce-quote');?></label>
							[shipping_first_name], [shipping_last_name], [shipping_company], [shipping_phone], [shipping_country], [shipping_state], [shipping_city], [shipping_post_code], [shipping_address_1], [shipping_address_2], [formatted_shipping_address]
							<br><br>
							<label><?php esc_html_e('Special', 'woocommerce-quote');?></label>
							<p><i><?php esc_html_e('[message] outputs the message text you can associate to the quote via the admin quote edit page.', 'woocommerce-quote');?></i></p>
							[message]
							<br><br><br>
							<label><?php esc_html_e('SPECIAL WRAPPERS', 'woocommerce-quote');?></label>
							<p><?php esc_html_e('You can use the following special wrappers to show the message text (if existing)', 'woocommerce-quote');?></p>
							<label><?php esc_html_e('Message', 'woocommerce-quote');?></label>
							[if_message] [end_message]
							<br><br>
						</div>
						<div class="wcqt_settings_row">
						<?php	
							
							$langs =  $wcqt_wpml_model->get_langauges_list();
							foreach($langs as $lang_data): ?>
									<div class="wcqt_editor_container">
										<?php if($lang_data['country_flag_url'] != "none"): ?>
											<img src=<?php esc_attr_e($lang_data['country_flag_url']); ?> /><label class="wcqt_label"> <?php echo ucwords($lang_data['language_code']); ?></label>
										<?php endif; 
										
										 $content = wcqt_get_value_if_set($texts , array('customer', 'new-quote', 'body', $lang_data['language_code']), "");
										 wp_editor( $content, "wcqt_customer_new_quote_editor_".$lang_data['language_code'], array( 'media_buttons' => false,
																														   'textarea_rows' => 8,
																														   'tinymce' => true,
																														   "wpautop" => true,
																														   'textarea_name'=>"wcqt_email_texts[customer][new-quote][body][".$lang_data['language_code']."]")); ?>
									</div>
							<?php endforeach; ?>
						</div>	
					</div>
					
					<h2 class="wcqt_section_title wcqt_no_margin_top"><?php esc_html_e('Customer - Accepted quote notification', 'woocommerce-quote');?></h2>
						
					<h3><?php esc_html_e('Heading', 'woocommerce-quote');?></h3> 
					<label><?php esc_html_e('You can use optionally use the [order_id] shortcode. ', 'woocommerce-quote');?></label>
					<?php foreach($langs as $lang_data): ?>
					<div class="wcqt_option_group">
						<div class="wcqt_editor_container">
							<?php $content = wcqt_get_value_if_set($texts , array('customer', 'accepted-quote', 'heading', $lang_data['language_code']), "");?>
							<input type="text" class="wcqt_subject" value="<?php esc_attr_e($content);?>" name="wcqt_email_texts[customer][accepted-quote][heading][<?php echo $lang_data['language_code']; ?>]"></input>
						</div>
					</div>	
					<?php endforeach; ?>
					<h3><?php esc_html_e('Subject', 'woocommerce-quote');?></h3> 
					<label><?php esc_html_e('You can use optionally use the [order_id] shortcode. ', 'woocommerce-quote');?></label>
					
					<?php foreach($langs as $lang_data): ?>
								<div class="wcqt_option_group">
									<?php if($lang_data['country_flag_url'] != "none"): ?>
										<img src=<?php esc_attr_e($lang_data['country_flag_url']); ?> /><label class="wcqt_label"> <?php echo ucwords($lang_data['language_code']); ?></label>
									<?php endif; 
									$content = wcqt_get_value_if_set($texts , array('customer', 'accepted-quote', 'subject', $lang_data['language_code']), "");
									?>
									<input type="text" class="wcqt_subject" value="<?php esc_attr_e($content);?>" name="wcqt_email_texts[customer][accepted-quote][subject][<?php echo $lang_data['language_code']; ?>]"></input>
								</div>
						<?php endforeach; ?>
					
					
					<h3><a id="messages"></a><?php esc_html_e('Message', 'woocommerce-quote');?></h3>
					<div class="wcqt_option_group">
						<div class="wcqt_shortcode_container">
							<label><?php esc_html_e('SHORTCODES', 'woocommerce-quote');?></label>
							<p><?php esc_html_e('You can use the following shortcodes:', 'woocommerce-quote');?></p>
							<label><?php esc_html_e('Quote data', 'woocommerce-quote');?></label>
							[order_id], [order_total], [order_date], [order_url]
							<br><br>
							<label><?php esc_html_e('Billing data', 'woocommerce-quote');?></label>
							[billing_first_name], [billing_last_name], [billing_email], [billing_company], [billing_company], [billing_phone], [billing_country], [billing_state], [billing_city], [billing_post_code], [billing_address_1], [billing_address_2], [formatted_billing_address]
							<br><br>
							<label><?php esc_html_e('Shipping data', 'woocommerce-quote');?></label>
							[shipping_first_name], [shipping_last_name], [shipping_company], [shipping_phone], [shipping_country], [shipping_state], [shipping_city], [shipping_post_code], [shipping_address_1], [shipping_address_2], [formatted_shipping_address]
							<br><br>
							<label><?php esc_html_e('Special', 'woocommerce-quote');?></label>
							<p><i><?php esc_html_e('[message] outputs the message text you can associate to the quote via the admin quote edit page.', 'woocommerce-quote');?></i></p>
							[message]
							<br><br><br>
							<label><?php esc_html_e('SPECIAL WRAPPERS', 'woocommerce-quote');?></label>
							<p><?php esc_html_e('You can use the following special wrappers to show the message text (if existing)', 'woocommerce-quote');?></p>
							<label><?php esc_html_e('Message', 'woocommerce-quote');?></label>
							[if_message] [end_message]
							<br><br>
						</div>
						<div class="wcqt_settings_row">
						<?php	
							
							$langs =  $wcqt_wpml_model->get_langauges_list();
							foreach($langs as $lang_data): ?>
									<div class="wcqt_editor_container">
										<?php if($lang_data['country_flag_url'] != "none"): ?>
											<img src=<?php esc_attr_e($lang_data['country_flag_url']); ?> /><label class="wcqt_label"> <?php echo ucwords($lang_data['language_code']); ?></label>
										<?php endif; 
										
										 $content = wcqt_get_value_if_set($texts , array('customer', 'accepted-quote', 'body', $lang_data['language_code']), "");
										 wp_editor( $content, "wcqt_customer_accepted_quote_editor_".$lang_data['language_code'], array( 'media_buttons' => false,
																														   'textarea_rows' => 8,
																														   'tinymce' => true,
																														   "wpautop" => true,
																														   'textarea_name'=>"wcqt_email_texts[customer][accepted-quote][body][".$lang_data['language_code']."]")); ?>
									</div>
							<?php endforeach; ?>
						</div>	
					</div>
					
					<h2 class="wcqt_section_title wcqt_no_margin_top"><?php esc_html_e('Customer - Rejected quote notification', 'woocommerce-quote');?></h2>
					
					<h3><?php esc_html_e('Heading', 'woocommerce-quote');?></h3> 
					<label><?php esc_html_e('You can use optionally use the [order_id] shortcode. ', 'woocommerce-quote');?></label>
					<?php foreach($langs as $lang_data): ?>
					<div class="wcqt_option_group">
						<div class="wcqt_editor_container">
							<?php $content = wcqt_get_value_if_set($texts , array('customer', 'rejected-quote', 'heading', $lang_data['language_code']), "");?>
							<input type="text" class="wcqt_subject" value="<?php esc_attr_e($content);?>" name="wcqt_email_texts[customer][rejected-quote][heading][<?php echo $lang_data['language_code']; ?>]"></input>
						</div>
					</div>	
					<?php endforeach; ?>
					<h3><?php esc_html_e('Subject', 'woocommerce-quote');?></h3> 
					<label><?php esc_html_e('You can use optionally use the [order_id] shortcode. ', 'woocommerce-quote');?></label>
					
					<?php foreach($langs as $lang_data): ?>
								<div class="wcqt_option_group">
									<?php if($lang_data['country_flag_url'] != "none"): ?>
										<img src=<?php esc_attr_e($lang_data['country_flag_url']); ?> /><label class="wcqt_label"> <?php echo ucwords($lang_data['language_code']); ?></label>
									<?php endif; 
									$content = wcqt_get_value_if_set($texts , array('customer', 'rejected-quote', 'subject', $lang_data['language_code']), "");
									?>
									<input type="text" class="wcqt_subject" value="<?php esc_attr_e($content);?>" name="wcqt_email_texts[customer][rejected-quote][subject][<?php echo $lang_data['language_code']; ?>]"></input>
								</div>
						<?php endforeach; ?>
					
					
					<h3><a id="messages"></a><?php esc_html_e('Message', 'woocommerce-quote');?></h3>
					<div class="wcqt_option_group">
						<div class="wcqt_shortcode_container">
							<label><?php esc_html_e('SHORTCODES', 'woocommerce-quote');?></label>
							<p><?php esc_html_e('You can use the following shortcodes:', 'woocommerce-quote');?></p>
							<label><?php esc_html_e('Quote data', 'woocommerce-quote');?></label>
							[order_id], [order_total], [order_date], [order_url]
							<br><br>
							<label><?php esc_html_e('Billing data', 'woocommerce-quote');?></label>
							[billing_first_name], [billing_last_name], [billing_email], [billing_company], [billing_company], [billing_phone], [billing_country], [billing_state], [billing_city], [billing_post_code], [billing_address_1], [billing_address_2], [formatted_billing_address]
							<br><br>
							<label><?php esc_html_e('Shipping data', 'woocommerce-quote');?></label>
							[shipping_first_name], [shipping_last_name], [shipping_company], [shipping_phone], [shipping_country], [shipping_state], [shipping_city], [shipping_post_code], [shipping_address_1], [shipping_address_2], [formatted_shipping_address]
							<br><br>
							<label><?php esc_html_e('Special', 'woocommerce-quote');?></label>
							<p><i><?php esc_html_e('[message] outputs the message text you can associate to the quote via the admin quote edit page.', 'woocommerce-quote');?></i></p>
							[message]
							<br><br><br>
							<label><?php esc_html_e('SPECIAL WRAPPERS', 'woocommerce-quote');?></label>
							<p><?php esc_html_e('You can use the following special wrappers to show the message text (if existing)', 'woocommerce-quote');?></p>
							<label><?php esc_html_e('Message', 'woocommerce-quote');?></label>
							[if_message] [end_message]
							<br><br>
						</div>
						<div class="wcqt_settings_row">
						<?php	
							
							$langs =  $wcqt_wpml_model->get_langauges_list();
							foreach($langs as $lang_data): ?>
									<div class="wcqt_editor_container">
										<?php if($lang_data['country_flag_url'] != "none"): ?>
											<img src=<?php esc_attr_e($lang_data['country_flag_url']); ?> /><label class="wcqt_label"> <?php echo ucwords($lang_data['language_code']); ?></label>
										<?php endif; 
										
										 $content = wcqt_get_value_if_set($texts , array('customer', 'rejected-quote', 'body', $lang_data['language_code']), "");
										 wp_editor( $content, "wcqt_rejected_quote_body_editor_".$lang_data['language_code'], array( 'media_buttons' => false,
																														   'textarea_rows' => 8,
																														   'tinymce' => true,
																														   "wpautop" => true,
																														   'textarea_name'=>"wcqt_email_texts[customer][rejected-quote][body][".$lang_data['language_code']."]")); ?>
									</div>
							<?php endforeach; ?>
						</div>	
					</div>
					
					<h2 class="wcqt_section_title wcqt_no_margin_top"><?php esc_html_e('Customer - Expiring quote notification', 'woocommerce-quote');?></h2>
					<h3><?php esc_html_e('Heading', 'woocommerce-quote');?></h3> 
					<label><?php esc_html_e('You can use optionally use the [order_id] shortcode. ', 'woocommerce-quote');?></label>
					<?php foreach($langs as $lang_data): ?>
					<div class="wcqt_option_group">
						<div class="wcqt_editor_container">
							<?php $content = wcqt_get_value_if_set($texts , array('customer', 'expiring-quote', 'heading', $lang_data['language_code']), "");?>
							<input type="text" class="wcqt_subject" value="<?php esc_attr_e($content);?>" name="wcqt_email_texts[customer][expiring-quote][heading][<?php echo $lang_data['language_code']; ?>]"></input>
						</div>
					</div>	
					<?php endforeach; ?>
					<h3><?php esc_html_e('Subject', 'woocommerce-quote');?></h3> 
					<label><?php esc_html_e('You can use optionally use the [order_id] shortcode. ', 'woocommerce-quote');?></label>
					
					<?php foreach($langs as $lang_data): ?>
								<div class="wcqt_option_group">
									<?php if($lang_data['country_flag_url'] != "none"): ?>
										<img src=<?php esc_attr_e($lang_data['country_flag_url']); ?> /><label class="wcqt_label"> <?php echo ucwords($lang_data['language_code']); ?></label>
									<?php endif; 
									$content = wcqt_get_value_if_set($texts , array('customer', 'expiring-quote','subject', $lang_data['language_code']), "");
									?>
									<input type="text" class="wcqt_subject" value="<?php esc_attr_e($content);?>" name="wcqt_email_texts[customer][expiring-quote][subject][<?php echo $lang_data['language_code']; ?>]"></input>
								</div>
						<?php endforeach; ?>
					
					
					<h3><a id="messages"></a><?php esc_html_e('Message', 'woocommerce-quote');?></h3>
					<div class="wcqt_option_group">
						<div class="wcqt_shortcode_container">
							<label><?php esc_html_e('SHORTCODES', 'woocommerce-quote');?></label>
							<p><?php esc_html_e('You can use the following shortcodes:', 'woocommerce-quote');?></p>
							<label><?php esc_html_e('Quote data', 'woocommerce-quote');?></label>
							[order_id], [order_total], [order_date], [order_url]
							<br><br>
							<label><?php esc_html_e('Billing data', 'woocommerce-quote');?></label>
							[billing_first_name], [billing_last_name], [billing_email], [billing_company], [billing_company], [billing_phone], [billing_country], [billing_state], [billing_city], [billing_post_code], [billing_address_1], [billing_address_2], [formatted_billing_address]
							<br><br>
							<label><?php esc_html_e('Shipping data', 'woocommerce-quote');?></label>
							[shipping_first_name], [shipping_last_name], [shipping_company], [shipping_phone], [shipping_country], [shipping_state], [shipping_city], [shipping_post_code], [shipping_address_1], [shipping_address_2], [formatted_shipping_address]
							<br><br>
							<label><?php esc_html_e('Special', 'woocommerce-quote');?></label>
							<p><i><?php esc_html_e('[message] outputs the message text you can associate to the quote via the admin quote edit page.', 'woocommerce-quote');?></i></p>
							[message], [expiring_date]
							<br><br><br><br>
							<label><?php esc_html_e('SPECIAL WRAPPERS', 'woocommerce-quote');?></label>
							<p><?php esc_html_e('You can use the following special wrappers to show the message text or expiring date (if existing)', 'woocommerce-quote');?></p>
							<label><?php esc_html_e('Message', 'woocommerce-quote');?></label>
							[if_message] [end_message]
							<br><br>
							<label><?php esc_html_e('Expiring date', 'woocommerce-quote');?></label>
							[if_expiring_date] [end_expiring_date]
							<br><br>
						</div>
						<div class="wcqt_settings_row">
						<?php	
							
							$langs =  $wcqt_wpml_model->get_langauges_list();
							foreach($langs as $lang_data): ?>
									<div class="wcqt_editor_container">
										<?php if($lang_data['country_flag_url'] != "none"): ?>
											<img src=<?php esc_attr_e($lang_data['country_flag_url']); ?> /><label class="wcqt_label"> <?php echo ucwords($lang_data['language_code']); ?></label>
										<?php endif; 
										
										 $content = wcqt_get_value_if_set($texts , array('customer', 'expiring-quote', 'body', $lang_data['language_code']), "");
										 wp_editor( $content, "wcqt_customer_expiring_quote_editor_".$lang_data['language_code'], array( 'media_buttons' => false,
																														   'textarea_rows' => 8,
																														   'tinymce' => true,
																														   "wpautop" => true,
																														   'textarea_name'=>"wcqt_email_texts[customer][expiring-quote][body][".$lang_data['language_code']."]")); ?>
									</div>
							<?php endforeach; ?>
						</div>
					</div>
					
					
					<h2 class="wcqt_section_title wcqt_no_margin_top"><?php esc_html_e('Admin - New quote submission notification', 'woocommerce-quote');?></h2>
					<h3><?php esc_html_e('Heading', 'woocommerce-quote');?></h3> 
					<label><?php esc_html_e('You can use optionally use the [order_id] shortcode. ', 'woocommerce-quote');?></label>
					<div class="wcqt_option_group">
						<div class="wcqt_editor_container">
							<?php $content = wcqt_get_value_if_set($texts , array('admin', 'new-quote', 'heading', $def_lang), "");?>
							<input type="text" class="wcqt_subject" value="<?php esc_attr_e($content);?>" name="wcqt_email_texts[admin][new-quote][heading][<?php echo $def_lang; ?>]"></input>
						</div>
					</div>	
					<h3><?php esc_html_e('Subject', 'woocommerce-quote');?></h3> 
					<label><?php esc_html_e('You can use optionally use the [order_id] shortcode. ', 'woocommerce-quote');?></label>
					<div class="wcqt_option_group">
						<div class="wcqt_editor_container">
							<?php $content = wcqt_get_value_if_set($texts , array('admin', 'new-quote','subject', $def_lang), "");?>
							<input type="text" class="wcqt_subject" value="<?php esc_attr_e($content);?>" name="wcqt_email_texts[admin][new-quote][subject][<?php echo $def_lang; ?>]"></input>
						</div>
					</div>	
					
					<h3><?php esc_html_e('Message', 'woocommerce-quote');?></h3> 
					<div class="wcqt_option_group">
						<div class="wcqt_shortcode_container">
						<label><?php esc_html_e('SHORTCODES', 'woocommerce-quote');?></label>
						<p><?php esc_html_e('You can use the following shortcodes:', 'woocommerce-quote');?></p>
						<label><?php esc_html_e('Quote data', 'woocommerce-quote');?></label>
							[order_id], [order_total], [order_date], [order_url]
							<br><br>
							<label><?php esc_html_e('Billing data', 'woocommerce-quote');?></label>
							[billing_first_name], [billing_last_name], [billing_email], [billing_company], [billing_company], [billing_phone], [billing_country], [billing_state], [billing_city], [billing_post_code], [billing_address_1], [billing_address_2], [formatted_billing_address]
							<br><br>
							<label><?php esc_html_e('Shipping data', 'woocommerce-quote');?></label>
							[shipping_first_name], [shipping_last_name], [shipping_company], [shipping_phone], [shipping_country], [shipping_state], [shipping_city], [shipping_post_code], [shipping_address_1], [shipping_address_2], [formatted_shipping_address]
							<br><br>
							<label><?php esc_html_e('Special', 'woocommerce-quote');?></label>
							[expiring_date]
							<br><br><br><br>
							<label><?php esc_html_e('SPECIAL WRAPPERS', 'woocommerce-quote');?></label>
							<p><?php esc_html_e('You can use the following special wrappers to show expiring date (if existing)', 'woocommerce-quote');?></p>
							<label><?php esc_html_e('Message', 'woocommerce-quote');?></label>
							[if_expiring_date] [end_expiring_date]
							<br><br>
							
						</div>
						<div class="wcqt_settings_row">
							<?php $content = wcqt_get_value_if_set($texts , array('admin', 'new-quote', 'body', $def_lang), "");
							wp_editor( $content, "wcqt_admin_new_quote_editor", array( 'media_buttons' => false,
																				   'textarea_rows' => 18,
																				   "wpautop" => true,
																				   'textarea_name'=>"wcqt_email_texts[admin][new-quote][body][{$def_lang}]")); ?>
							
						</div>	
					</div>
					
					<h2 class="wcqt_section_title wcqt_no_margin_top"><?php esc_html_e('Admin - Rejected quote notification', 'woocommerce-quote');?></h2>
					<h3><?php esc_html_e('Heading', 'woocommerce-quote');?></h3> 
					<label><?php esc_html_e('You can use optionally use the [order_id] shortcode. ', 'woocommerce-quote');?></label>
					<div class="wcqt_option_group">
						<div class="wcqt_editor_container">
							<?php $content = wcqt_get_value_if_set($texts , array('admin', 'rejected-quote-2', 'heading', $def_lang), "");?>
							<input type="text" class="wcqt_subject" value="<?php esc_attr_e($content);?>" name="wcqt_email_texts[admin][rejected-quote-2][heading][<?php echo $def_lang; ?>]"></input>
						</div>
					</div>	
					<h3><?php esc_html_e('Subject', 'woocommerce-quote');?></h3> 
					<label><?php esc_html_e('You can use optionally use the [order_id] shortcode. ', 'woocommerce-quote');?></label>
					<div class="wcqt_option_group">
						<div class="wcqt_editor_container">
							<?php $content = wcqt_get_value_if_set($texts , array('admin', 'rejected-quote-2','subject', $def_lang), "");?>
							<input type="text" class="wcqt_subject" value="<?php esc_attr_e($content);?>" name="wcqt_email_texts[admin][rejected-quote-2][subject][<?php echo $def_lang; ?>]"></input>
						</div>
					</div>	
					
					<h3><?php esc_html_e('Message', 'woocommerce-quote');?></h3> 
					<div class="wcqt_option_group">
						<div class="wcqt_shortcode_container">
						<label><?php esc_html_e('SHORTCODES', 'woocommerce-quote');?></label>
						<p><?php esc_html_e('You can use the following shortcodes:', 'woocommerce-quote');?></p>
						<label><?php esc_html_e('Quote data', 'woocommerce-quote');?></label>
							[order_id], [order_total], [order_date], [order_url]
							<br><br>
							<label><?php esc_html_e('Billing data', 'woocommerce-quote');?></label>
							[billing_first_name], [billing_last_name], [billing_email], [billing_company], [billing_company], [billing_phone], [billing_country], [billing_state], [billing_city], [billing_post_code], [billing_address_1], [billing_address_2], [formatted_billing_address]
							<br><br>
							<label><?php esc_html_e('Shipping data', 'woocommerce-quote');?></label>
							[shipping_first_name], [shipping_last_name], [shipping_company], [shipping_phone], [shipping_country], [shipping_state], [shipping_city], [shipping_post_code], [shipping_address_1], [shipping_address_2], [formatted_shipping_address]
							<br><br>
							<label><?php esc_html_e('Special', 'woocommerce-quote');?></label>
							[expiring_date]
							<br><br><br><br>
							<label><?php esc_html_e('SPECIAL WRAPPERS', 'woocommerce-quote');?></label>
							<p><?php esc_html_e('You can use the following special wrappers to show expiring date (if existing)', 'woocommerce-quote');?></p>
							<label><?php esc_html_e('Message', 'woocommerce-quote');?></label>
							[if_expiring_date] [end_expiring_date]
							<br><br>
							
						</div>
						<div class="wcqt_settings_row">
							<?php $content = wcqt_get_value_if_set($texts , array('admin', 'rejected-quote-2', 'body', $def_lang), "");
							wp_editor( $content, "wcqt_admin_quote_rejected_editor", array( 'media_buttons' => false,
																				   'textarea_rows' => 18,
																				   "wpautop" => true,
																				   'textarea_name'=>"wcqt_email_texts[admin][rejected-quote-2][body][{$def_lang}]")); ?>
							
						</div>	
					</div>
					
					<p class="submit">
						<input name="submit" type="submit" class="button-primary" value="<?php esc_attr_e('Save', 'woocommerce-quote'); ?>" />
					</p>
			</form>			
		</div>
		<?php 
	}
}
?>