<?php 
namespace WCQT\classes\admin;

class FormPage
{
	public function __construct()
	{
		
	}
	public function render_page()
	{
		global $wcqt_option_model, $wcqt_wpml_model, $wcqt_option_model, $wcqt_html_model, $wcqt_product_model, $wcqt_user_model, $wcqt_html_model;
		
		$langs =  $wcqt_wpml_model->get_langauges_list();
		$available_langs = array();
		foreach($langs as $lang_data)
			$available_langs[] = $lang_data['language_code'];
		
		$variables = array(
			'confirm_delete_message' => __('Are you sure?', 'woocommerce-quote'),
			'show_options' => __('Show options', 'woocommerce-quote'),
			'hide_options' => __('Hide options', 'woocommerce-quote'),
			'yes_text' => __('Yes', 'woocommerce-quote'),
			'no_text' => __('No', 'woocommerce-quote'),
			'available_langs' => $available_langs,
			'curr_lang' => $wcqt_wpml_model->get_current_language(),
			'security' => wp_create_nonce('wcqt_admin_form_page')
		);
		//Save & Retrieval
		$options = $wcqt_option_model->get_form_options();
		
		wp_enqueue_style('magnificpopup', WCQT_PLUGIN_PATH.'/css/vendor/magnificpopup/magnific-popup.css');
		wp_enqueue_style( 'select2.css', WCQT_PLUGIN_PATH.'/css/vendor/select2/select2.min.css' );
		wp_enqueue_style( 'wcqt-admin-common', WCQT_PLUGIN_PATH.'/css/admin/common.css');
		wp_enqueue_style( 'wcqt-admin-toggle', WCQT_PLUGIN_PATH.'/css/com/toggle.css');
		wp_enqueue_style( 'wcqt-admin-table', WCQT_PLUGIN_PATH.'/css/com/table.css');
		wp_enqueue_style( 'wcqt-form-page', WCQT_PLUGIN_PATH.'/css/admin/form-page.css');
		wp_enqueue_style('datetime-picker', WCQT_PLUGIN_PATH.'/css/vendor/datetimepicker/default.css'); 
		wp_enqueue_style('datetime-picker-date', WCQT_PLUGIN_PATH.'/css/vendor/datetimepicker/default.date.css'); 
		wp_enqueue_style('datetime-picker-time', WCQT_PLUGIN_PATH.'/css/vendor/datetimepicker/default.time.css'); 
		 
		
		wp_register_script( 'wcqt-form-page', WCQT_PLUGIN_PATH.'/js/admin/form-page.js', array('jquery') );	
		
		wp_enqueue_script( 'wp-tinymce');	
		wp_enqueue_script( 'selectWoo' );
		wp_enqueue_script( 'jquery-ui-sortable' );
		wp_enqueue_script( 'datetime-picker', WCQT_PLUGIN_PATH.'/js/vendor/datetimepicker/picker.js', array('jquery'));	
		wp_enqueue_script( 'datetime-picker-date', WCQT_PLUGIN_PATH.'/js/vendor/datetimepicker/picker.date.js', array('jquery'));	
		wp_enqueue_script( 'datetime-picker-time', WCQT_PLUGIN_PATH.'/js/vendor/datetimepicker/picker.time.js', array('jquery'));	
		wp_enqueue_script( 'magnificpopup', WCQT_PLUGIN_PATH.'/js/vendor/magnificpopup/jquery.magnific-popup.min.js', array('jquery'));		

		
		wp_localize_script( 'wcqt-form-page', 'wcqt', $variables );			
		wp_enqueue_script( 'wcqt-form-page');	
		
		if ($_SERVER['REQUEST_METHOD'] == 'POST'): ?>
			<div class="notice notice-success is-dismissible">
				 <p><?php esc_html_e('Saved successfully!', 'woocommerce-quote'); ?></p>
			</div>
		<?php endif; ?>
			
		<div class="wrap white-box">
			
			
				<h2 class="wcqt_section_title wcqt_no_margin_top"><?php esc_attr_e('Contact form', 'woocommerce-quote'); ?></h2>
				<p><?php esc_html_e("This is the form that can be filled by the customer before submitting the quote", 'woocommerce-quote');?></p>
					<select id="wcqt_input_fields_type">
					  <option value="text" ><?php _e('Text', 'woocommerce-quote');?></option>
					  <option value="email" ><?php _e('Email', 'woocommerce-quote');?></option>
					  <option value="textarea" ><?php _e('Textarea', 'woocommerce-quote');?></option>
					  <option value="date" ><?php _e('Date', 'woocommerce-quote');?></option>
					  <option value="time" ><?php _e('Time', 'woocommerce-quote');?></option>
					  <option value="select" ><?php _e('Select/Multiselect', 'woocommerce-quote');?></option>
					  <option value="checkbox" ><?php _e('Acceptance', 'woocommerce-quote');?></option>
					  <option value="country-state" ><?php _e('Country & state', 'woocommerce-quote');?></option>
				</select>
				<button class="button-primary wcqt_add_new_input_field_button disable_during_animation" ><?php esc_attr_e('Add new', 'woocommerce-quote'); ?></button>
				<div class="spinner load_new_input_field_spinner"></div>	
				<div class="wcqt_input_fields_container" id="wcqt_input_fields_container">
					<table class="van-table" id="input-fields-table">
						<thead>
							<tr>
							<th class=""><?php _e('Type', 'woocommerce-quote');?></th>
							<th class=""><?php _e('Label', 'woocommerce-quote');?></th>
							<th class=""><?php _e('Connect to', 'woocommerce-quote');?></th>
							<th class=""><?php _e('Required', 'woocommerce-quote');?></th>
							<th class=""><?php _e('Disabled', 'woocommerce-quote');?></th>
							<th class=""><?php _e('Actions', 'woocommerce-quote');?></th>
							</tr>
					</thead>
					<tbody class="ui-sortable" id="input-fields-table-body">
					<?php 
					
						if(isset($options ))
							foreach((array)$options as $input_field_id => $input_field_data)
							{
								$wcqt_html_model->add_new_admin_input_field($input_field_data['type'], $input_field_data, $input_field_id);
							}
					?>
					</tbody>
					</table>
				</div>	
				
				
			
			
		</div>
		<?php 
	}
}
?>