<?php
namespace WCQT\classes\admin;

class ProductPage
{
	function __construct()
	{
		add_action('woocommerce_variation_options',array($this,'add_options_to_variation'),1,3);
		add_action('woocommerce_product_options_general_product_data', array($this,'add_options_to_simple_product'));
		
		add_action( 'woocommerce_process_product_meta',  array( $this, 'save_data') );
		add_action( 'wp_ajax_woocommerce_save_variations',  array( $this, 'ajax_save_data') );
	}
	public function save_data($product_id)
	{
		global $wcqt_option_model, $wcqt_wpml_model;
		
		$product_id			= $wcqt_wpml_model->get_original_id($product_id);
		$options 			= $wcqt_option_model->get_options();
		$wc_product 		= wc_get_product($product_id);
		$selected_products 	= wcqt_get_value_if_set($options, array('exclusion', 'products'), array());
		$quotable_products	= wcqt_get_value_if_set($_POST, '_is_quotable', array());
		$current_products	= $wc_product->get_type('get_type') == "simple" ? [$product_id] : $wc_product->get_children();
		
		foreach($current_products as $product_id)
			if(wcqt_get_value_if_set($quotable_products, $product_id, false) == 'yes')
			{
				if(!in_array($product_id, $selected_products))
					$selected_products[] = $product_id;
			}
			else
				if (($key = array_search($product_id, $selected_products)) !== false) 
					unset($selected_products[$key]);
		
		if(!isset($options['exclusion']))
			$options['exclusion'] = [];
		$options['exclusion']['products'] = $selected_products;
		
		$wcqt_option_model->save_options($options);
		
	}
	public function ajax_save_data()
	{
		$this->save_data($_POST['product_id']);
	}
	public function add_options_to_variation($loop, $variation_data, $variation )
	{
		global $wcqt_option_model, $wcqt_wpml_model;
		$options = $wcqt_option_model->get_options();
		$id = $wcqt_wpml_model->get_original_id($variation->ID, "product_variation");
		$selected_products = wcqt_get_value_if_set($options, array('exclusion', 'products'), array());
		
		woocommerce_wp_checkbox(
				array(
					'id'            => '_is_quotable['.$id.']',
					'value'         => in_array($id, $selected_products) ? 'yes' : 'no',
					'wrapper_class' => 'show_if_simple show_if_variable',
					'label'         => esc_html__( ' Is the variation quotable?', 'woocommerce-quote' ),
					'description'   => wcqt_html_escape_allowing_special_tags( __('<br/><small>The product can be added to/exclude from the quotable list.The add/exclusion is determined according to the Exclusion policy setting you can set via the Woocomemrce Quote -> Settings menu</small>', 'woocommerce-quote' ), false),
				)
			);
	}
	public function add_options_to_simple_product()
	{
		global $wcqt_option_model,  $post, $wcqt_wpml_model;
		$options 			= $wcqt_option_model->get_options();
		$selected_products 	= wcqt_get_value_if_set($options, array('exclusion', 'products'), array());
		$id 				= $wcqt_wpml_model->get_original_id($post->ID);
		$wc_product 		= wc_get_product($id);
		/* if($wc_product->get_type('get_type') != "simple" )
			return; */
		
		woocommerce_wp_checkbox(
				array(
					'id'            => '_is_quotable['.$id.']',
					'value'         => in_array($id, $selected_products) ? 'yes' : 'no',
					'wrapper_class' => 'show_if_simple show_if_variable',
					'label'         => esc_html__( 'Is the product quotable?', 'woocommerce-quote' ),
					'description'   => wcqt_html_escape_allowing_special_tags( __( 'The product can be added to/exclude from the quotable list.<br><small>The add/exclusion is determined according to the Exclusion policy setting you can set via the Woocomemrce Quote -> Settings menu</small>', 'woocommerce-quote' ), false),
				)
			);
	}
}
?>