<?php
namespace WCQT\classes\admin;

use Automattic\WooCommerce\Utilities\OrderUtil;
use Automattic\WooCommerce\Internal\DataStores\Orders\CustomOrdersTableController;

class QuoteDetailsPage
{
	function __construct()
	{
		add_action( 'woocommerce_admin_order_data_after_order_details',  array( $this,'display_custom_data' ));
		add_action( 'add_meta_boxes', array( $this, 'woocommerce_metaboxes' ));
		
		add_action( 'woocommerce_process_shop_order_meta', array( &$this, 'save_data' ), 5, 2 );
	}
	public function woocommerce_metaboxes()
	{
		global $post, $order, $wcqt_order_model;
		
		$screen = 'shop_order';
		try
		{
			$screen = wc_get_container()->get( CustomOrdersTableController::class )->custom_orders_table_usage_is_enabled()
			? wc_get_page_screen_id( 'shop-order' )
			: 'shop_order';
		}
		catch (Exception $e) {$screen = 'shop_order';}
		
		if( OrderUtil::custom_orders_table_usage_is_enabled() ) 
		{
			if(!$order || !$wcqt_order_model->is_quote($order->get_id()));
		}
		else 
		{
			if(!$post || !$wcqt_order_model->is_quote($post->ID));
			return;
		}
		
		add_meta_box( 'woocommerce-quote', esc_html__('WooCommerce Quote', 'woocommerce-quote'), array( $this, 'render_meta_box' ), $screen, 'normal', 'default');
	}
	public function display_custom_data( $order ) 
	{
		wp_enqueue_style('wcqt-quote-details-page', WCQT_PLUGIN_PATH.'/css/admin/quote-details-page.css');
	    wp_enqueue_script( 'wcqt-quotes-details-page', WCQT_PLUGIN_PATH.'/js/admin/quote-details-page.js', array('jquery') );
		
		global $wcqt_input_field_model, $wcqt_order_model, $wcqt_wpml_model;
		
		$input_field_data = $wcqt_order_model->get_input_fields_data($order);	
		$form_data = $wcqt_order_model->get_form_data($order);	
		$current_lang = $wcqt_wpml_model->get_current_language();
		
		if(!is_array($input_field_data) || empty($input_field_data))
			return;
		
		?>
		<div class="wcqt-order-details-column">
			<h2><?php esc_html_e('Form data', 'woocommerce-quote'); ?></h2>
			<?php foreach($input_field_data as $field_id => $input_field): ?>
			<p class="form-field form-field-wide">
			  <label class="wcqt-label"><?php esc_html_e($input_field['label'][$current_lang]); ?></label>
			  <?php if(isset($form_data[$field_id])): 
						$value_raw = $form_data[$field_id];
						$value = $wcqt_input_field_model->get_value_by_type($value_raw, $input_field['type']);
						$connects_to = wcqt_get_value_if_set($input_field, 'connects_to', "none");
						
						
						
						if($input_field['type'] != 'country-state')
							echo $value;
						else 
							echo $value_raw['country']." ".$value_raw['state'];
			  ?>
				
			  <?php endif; ?>
			</p>		
			<?php endforeach; ?>
		</div>
		<?php
	}
	function render_meta_box($post) 
	{
		global $wcqt_order_model;
		
		$order_id = $post->ID;
		$order = wc_get_order($order_id);
		
		$expiring_datetime = $wcqt_order_model->get_expiring_date($order);
		$msg = $wcqt_order_model->get_message($order);
		$is_disabled = empty($expiring_datetime['date']);
		$time = $expiring_datetime['date'] && $expiring_datetime['time'] ? explode(":", $expiring_datetime['time']) : array(0 => "", 1 =>"");
		 
		
		?>
		<div clss="wcqt-expiring-datetime-wrapper">
			<label class="wcqt-label"><?php  esc_html_e('Expiring date', 'woocommerce-quote'); ?></label>
			<p>
				<?php wp_nonce_field( 'admin-update-quote', 'wcqt-once' ); ?>
				<select name="wcqt-data[disable_exipring]">
					<option <?php selected(!$is_disabled); ?> value="enable"><?php  esc_html_e('Enable', 'woocommerce-quote'); ?></option>
					<option <?php selected($is_disabled); ?> value="disable"><?php  esc_html_e('Disable', 'woocommerce-quote'); ?></option>
				</select>
				<input type="text" class="wcqt-date-picker" placeholder="<?php  esc_attr_e('Date', 'woocommerce-quote'); ?>" name="wcqt-data[expiring_date]" value="<?php echo $expiring_datetime['date']; ?>" pattern="[0-9]{4}-(0[1-9]|1[012])-(0[1-9]|1[0-9]|2[0-9]|3[01])"></input>@
				<input type="number" class="hour wcqt-hour-picker" placeholder="<?php  esc_attr_e('Hour', 'woocommerce-quote'); ?>" name="wcqt-data[expiring_hour]" min="0" max="23" step="1" value="<?php echo $time[0]; ?>" pattern="([01]?[0-9]{1}|2[0-3]{1})">:
				<input type="number" class="minute wcqt-minute-picker" placeholder="<?php  esc_attr_e('Minute', 'woocommerce-quote'); ?>" name="wcqt-data[expiring_minute]" min="0" max="59" step="1" value="<?php echo $time[1]; ?>" pattern="[0-5]{1}[0-9]{1}">
			</p>
			<label class="wcqt-label"><?php  esc_html_e('Message', 'woocommerce-quote'); ?></label>
			<?php 
			wp_editor( $msg, "wcqt-message", array( 'media_buttons' => false,
														   'textarea_rows' => 8,
														   'tinymce' => true,
														   "wpautop" => true,
														   'textarea_name'=>"wcqt-data[message]")); ?>
		</div>
		<p>
		<?php esc_html_e('To save, hit the order "Update button".', 'woocommerce-quote');?>
		</p>
		<?php 
	}
	function save_data( $order_id, $post_obj ) 
	{
		global $wcqt_order_model;
		if(!$wcqt_order_model->is_quote($order_id))
			return;
		
		if(!wp_verify_nonce( wcqt_get_value_if_set($_POST, 'wcqt-once', ""), 'admin-update-quote' ))
			return;
		
		
		//Expiring date
		if(wcqt_get_value_if_set($_POST, array('wcqt-data', 'disable_exipring'), "enable") == "disable" || wcqt_get_value_if_set($_POST, array('wcqt-data', 'expiring_date'), "") == "")
		{
			$wcqt_order_model->update_expiring_date($order_id, "", true);
		}
		else
		{
			$date = wcqt_get_value_if_set($_POST, array('wcqt-data', 'expiring_date'), "");
			$hour = sprintf("%02d", wcqt_get_value_if_set($_POST, array('wcqt-data', 'expiring_hour'), "00"));
			$minute = sprintf("%02d",wcqt_get_value_if_set($_POST, array('wcqt-data', 'expiring_minute'), "00"));
			$wcqt_order_model->update_expiring_date($order_id, $date." ".$hour.":".$minute.":"."00", true);
		}
		//Msg
		$msg = wcqt_get_value_if_set($_POST, array('wcqt-data', 'message'), "");
		$wcqt_order_model->update_message($order_id, $msg);
	}
}
?>