<?php 
namespace WCQT\classes\admin;

class QuotesConfigurationPage
{
	public function render_page()
		{
			global $wcqt_option_model, $wcqt_wpml_model, $wcqt_option_model, $wcqt_html_model;
			
			wp_enqueue_style( 'wcqt-admin-common', WCQT_PLUGIN_PATH.'/css/admin/common.css');
			wp_enqueue_style( 'wcqt-admin-toggle', WCQT_PLUGIN_PATH.'/css/com/toggle.css');
			wp_enqueue_style( 'wcqt-admin-quotes-page', WCQT_PLUGIN_PATH.'/css/admin/quotes-page.css');
			
			wp_enqueue_style('van-tooltip', WCQT_PLUGIN_PATH.'/css/vendor/vanquish/tooltip.css'); 
		
			wp_register_script( 'wcqt-configurator-page', WCQT_PLUGIN_PATH.'/js/admin/quotes-page.js', array('jquery') );	
			
			if (isset($_POST['wcqt_field_options']) || isset($_POST['wcqt_is_submit']) )
			{
				$quotes_options = $wcqt_option_model->set_quotes_options(wcqt_get_value_if_set($_POST,'wcqt_field_options', null));
			}
			else
				$quotes_options = $wcqt_option_model->get_quotes_options(); 
			
			$next_id = is_int($wcqt_option_model->get_last_quote_id()) ? $wcqt_option_model->get_last_quote_id() + 1 : 0;
			
			$langs =  $wcqt_wpml_model->get_langauges_list();
			$available_langs = array();
			foreach($langs as $lang_data)
				$available_langs[] = $lang_data['language_code'];
				
			$variables = array(
				'next_id' => $next_id,
				'confirm_delete_message' => __('Are you sure you want to delete the field?', 'woocommerce-quote'),
				'show_options' => __('Show options', 'woocommerce-quote'),
				'hide_options' => __('Hide options', 'woocommerce-quote'),
				'available_langs' => $available_langs,
				'security' => wp_create_nonce('wcqt_admin_field_configurator_page')
			);
			wp_localize_script( 'wcqt-configurator-page', 'wcqt', $variables );	
			wp_enqueue_script( 'wcqt-configurator-page');	
			wp_enqueue_script( 'wp-tinymce');	
			
			wp_enqueue_script( 'datetime-picker', WCQT_PLUGIN_PATH.'/js/vendor/datetimepicker/picker.js', array('jquery'));	
			wp_enqueue_script( 'datetime-picker-date', WCQT_PLUGIN_PATH.'/js/vendor/datetimepicker/picker.date.js', array('jquery'));	
			wp_enqueue_script( 'datetime-picker-time', WCQT_PLUGIN_PATH.'/js/vendor/datetimepicker/picker.time.js', array('jquery'));	
			

			
			$allowed_tags = array('strong' => array());
			
			if ($_SERVER['REQUEST_METHOD'] == 'POST'): ?>
				<div class="notice notice-success is-dismissible">
					 <p><?php esc_html_e('Saved successfully!', 'woocommerce-quote'); ?></p>
				</div>
			<?php endif; ?>
				
			<div id="wcqt_main_container">
				<div class="wcqt_info">
						<h3><?php esc_html_e('Info', 'woocommerce-quote'); ?></h3> 
						<p><?php echo wp_kses(__('Here you can add new quotes or edit the existing ones. Click the <strong>Add new</strong> button to create a new Quote. Once done, click the <strong>Save</strong> button to save your creations!', 'woocommerce-quote'), $allowed_tags); ?></p> 
					</div>
					
				<form action="" method="post" >
					
					
					<div id="wcqt_quotes_container">
					<?php if($quotes_options)
							$wcqt_html_model->get_quote_configuration_template($quotes_options); ?>
					</div>
					
					<button class="button-primary wcqt_add_new_button disable_during_animation"  ><?php esc_attr_e('Add new', 'woocommerce-quote'); ?></button>
					<div class="spinner load_new_quote_spinner"></div>
				
					<p class="submit">
						<input name="wcqt_is_submit" type="submit" class="button-primary wcqt_save_button disable_during_animation" value="<?php esc_attr_e('Save', 'woocommerce-quote'); ?>" />
					</p>
				</form>
				
				
			</div>
			<?php
		}
}
?>