<?php 
namespace WCQT\classes\com;

class HTML
{	
	var $quotes_is_ajax_request = false;
	var $input_fields_is_ajax_request = false;
	function __construct()
	{
		add_action('wp_ajax_wcqt_add_new_input_field', array($this,'ajax_add_new_admin_input_field'));
		
		//not used for now: add_action('wp_ajax_wcqt_duplicate_field', array($this,'ajax_duplicate_quote'));
		//not used for now: add_action('wp_ajax_wcqt_add_new_input_field', array($this,'ajax_add_new_admin_input_field'));
	}
	public function create_custom_nav_menu_item( $title, $url, $order, $parent = 0 )
	{
		  $item = (object) array(); //it means new stdClass()
		  $item->ID = 3000000 + $order + $parent;
		  $item->db_id = $item->ID;
		  $item->title = $title;
		  $item->url = $url;
		  $item->menu_order = $order;
		  $item->menu_item_parent = $parent;
		  $item->type = '';
		  $item->object = '';
		  $item->object_id = '';
		  $item->classes = array('wcqt_menu_element');
		  $item->target = '';
		  $item->attr_title = '';
		  $item->description = '';
		  $item->xfn = '';
		  $item->status = '';
		  return $item;
	}
	function merge_menu_arrays($array1, $array2, $position = 'before')
{
	$result = array();
	if($position == 'before')
	{
		foreach($array2 as $elem)
			$result[] = $elem;
		foreach($array1 as $elem)
			$result[] = $elem;
	}
	else 
	{
		foreach($array1 as $elem)
			$result[] = $elem;
		foreach($array2 as $elem)
			$result[] = $elem;
	}
	
	return $result;
} 
	
	
	public function ajax_add_new_admin_input_field()
	{
		$this->input_fields_is_ajax_request = true;
		if(wp_verify_nonce( wcqt_get_value_if_set($_POST, 'security', ""), 'wcqt_admin_form_page' ))
			$this->add_new_admin_input_field(wcqt_get_value_if_set($_POST, 'type', "text"));
		wp_die();
	}
	public function add_new_admin_input_field($type, $field_data = array(), $input_field_id = -1)
	{
		global $wcqt_wpml_model, $wcqt_order_model;
		$input_field_id = $input_field_id < 0 ? rand(0, 3129120123) : $input_field_id;
		$allowed_tags = array('br' => array(), 'p' => array(), 'strong' => array(), 'i' => array());
		
		include WCQT_PLUGIN_ABS_PATH."/templates/admin/input-fields/{$type}.php";
	}
	function render_frontend_input_field($input_field, $input_field_key)
	{
		global $wcqt_wpml_model, $wcqt_time_model, $wcqt_input_field_model, $wcqt_country_model, $wcqt_user_model;
		
		$current_lang = $wcqt_wpml_model->get_current_language();
		///Autofill management
		$autofill = wcqt_get_value_if_set($input_field, 'autofill', false) == "true" && wcqt_get_value_if_set($input_field, 'connects_to', "none") != "none";
		$value = "";
		$state_value = "";
		$autofill_data = !$autofill ? array('value'=> "", "state_value" => "") : $wcqt_user_model->get_profile_value(wcqt_get_value_if_set($input_field, 'connects_to', null));
		
		if(file_exists ( get_theme_file_path()."/wcqt/input/{$input_field['type']}.php" ))
			include get_theme_file_path()."/wcqt/input-fields/{$input_field['type']}.php";
		else
			include WCQT_PLUGIN_ABS_PATH."/templates/frontend/input-fields/{$input_field['type']}.php";
	}
	function get_quote_configuration_template($fields_data = array())
	{
		global $wcqt_wpml_model, $wcqt_user_model;
		$allowed_tags = array('br' => array(), 'p' => array(), 'strong' => array(), 'i' => array(), 'span' => array());
		$langs =  $wcqt_wpml_model->get_langauges_list();
		
		foreach($fields_data as $field_id => $field_data): ?>
		<div class="wrap white-box" id="wcqt_field_container_<?php echo $field_id; ?>">
			<div class="wcqt_title_container">
						<label class="wcqt_required wcqt_no_margin_top"><?php echo sprintf(esc_html__('[wcqt_quote id="%d"]', 'woocommerce-quote'), $field_id);?></label>
						<input type ="hidden" class="wcqt_field_options_id" name= "wcqt_field_options[<?php echo $field_id ?>][id]" value="<?php echo $field_id; ?>" ></input>
						<input type="text" placeholder="<?php  esc_html_e('Type the upload field title. HTML code is not allowed.', 'woocommerce-quote'); ?>" class="wcqt_quote_name" value="<?php esc_html_e(wcqt_get_value_if_set($field_data, 'title')); ?>" name="wcqt_field_options[<?php echo $field_id ?>][title]"  size="90" required></input >
						<button data-id="<?php echo $field_id ?>" class="button wcqt_collapse_options" id="wpuef_show_options_button_<?php echo $field_id; ?>"><?php esc_html_e('Show options', 'woocommerce-quote');?></button>
						<?php if(!empty($field_data)): ?>
						<a class="wcqt_tooltip duplicate_field button-secondary " data-id="<?php echo $field_id ?>">
							
								<?php esc_html_e('Duplicate field*', 'woocommerce-files-upload'); ?>
								<span><?php esc_html_e('The latest saved version will be the one that will be duplicated. So before duplicating a field, save it before.', 'woocommerce-files-upload');?></span>
						</a>
						<?php endif; ?>
						<button class="wcqt_remove_field button button-delete" data-id="<?php echo $field_id ?>"><?php esc_html_e('Delete field', 'woocommerce-quote');?></button>
			</div>
			<div class="wcqt_options_container" id="wcqt_options_container_<?php echo $field_id; ?>">
				<div class="wcqt_options_inner_container" id="wcqt_options_inner_container_<?php echo $field_id; ?>">
					<div class="wcqt_section_header_container header_container_small_margin">
						<h3 class="tab-title"><?php esc_html_e('Description, file types restriction, etc.', 'woocommerce-quote');?></h3>
					</div>
					<div class="half_block_fixed_container">
						<label class="option_label"><?php esc_html_e('Description (HTML code permitted)', 'woocommerce-quote');?></label>
						<?php foreach($langs as $lang_data): ?>
							<div class="wcqt_description_container">
								<?php if($lang_data['country_flag_url'] != "none"): ?>
									<img src=<?php esc_attr_e($lang_data['country_flag_url']); ?> /><label class="wcqt_label"> <?php esc_attr_e($lang_data['language_code']); ?></label>
								<?php endif; 
								$content = wcqt_get_value_if_set($field_data , array('description', $lang_data['language_code']), ""); 
								/* In case of rich editor text, the following code should be used: 
									wp_editor( $content, "wcqt_field_description_editor_{$field_id}_{$lang_data['language_code']}", array( 'media_buttons' => false,
																												   'textarea_rows' => 5,
																												   'tinymce' => true,
																												   "wpautop" => false,
																												   'editor_height' => 350,
																												   'textarea_name'=>"wcqt_field_options[{$field_id}][description][".$lang_data['language_code']."]"));*/
								?>
								<textarea class="upload_description"  rows="5" cols="80" name="wcqt_field_options[<?php echo $field_id ?>][description][<?php echo $lang_data['language_code']; ?>]" placeholder="<?php esc_html_e('Description (HTML code permitted)', 'woocommerce-quote'); ?>"><?php echo $content ?></textarea>
							</div>
					<?php endforeach; ?>
					
						
					</div>
							
					<div class="half_block_fixed_container">
						<label class="option_label"><?php esc_html_e('Allowed file type(s)', 'woocommerce-quote');?></label>
						<input type="text" name="wcqt_field_options[<?php echo $field_id ?>][types]" placeholder="<?php esc_html_e('File type(s), ex: .jpg,.bmp,.png leave empty to accept all file types. ', 'woocommerce-quote'); ?>" value="<?php echo wcqt_get_value_if_set($field_data, 'types') ?>" size="80"></input>
						
						<label class="option_label"><?php esc_html_e('Anonymous upload', 'woocommerce-quote');?></label>
						<p><?php esc_html_e('Allow not logged user to perform the upload', 'woocommerce-quote');?></p>
						<label class="switch">
								<input type="checkbox" name="wcqt_field_options[<?php echo $field_id ?>][anonymous_upload]" value="true" <?php checked(wcqt_get_value_if_set($field_data, 'anonymous_upload', "false"), "true") ?> ></input>
								<span class="slider"></span>
						</label>
						
						<label class="option_label"><?php esc_html_e('Single submission', 'woocommerce-quote');?></label>
						<p><?php esc_html_e('The user can perform an upload only one time. If this option is enabled, the user must be logged.', 'woocommerce-quote');?></p>
						<label class="switch">
								<input type="checkbox" name="wcqt_field_options[<?php echo $field_id ?>][single_submission]" class="master_option" data-related-id="user_can_delete_<?php echo $field_id ?>" data-id="<?php echo $field_id ?>" value="true" <?php checked(wcqt_get_value_if_set($field_data, 'single_submission', false), "true") ?> ></input>
								<span class="slider"></span>
						</label>
							
						<!-- <div class="master_related_user_can_delete_<?php echo $field_id ?> wcqt_master_related <?php if(!wcqt_get_value_if_set($field_data, 'user_can_delete', false)) echo 'wcqt_hidden'; ?>" >
							<label class="option_label"><?php esc_html_e('Can user delete file(s)?', 'woocommerce-quote');?></label>
							<p><?php esc_html_e('Once uploaded, the user will be able to delete and re-upload new files.', 'woocommerce-quote');?></p>
							<label class="switch">
								<input type="checkbox" name="wcqt_field_options[<?php echo $field_id ?>][user_can_delete]" value="true" <?php checked(wcqt_get_value_if_set($field_data, 'user_can_delete', "false"), "true") ?> ></input>
								<span class="slider"></span>
							</label>
						</div> -->
						
						<label class="option_label"><?php esc_html_e('Field container width', 'woocommerce-quote');?></label>
						<p><?php wcqt_html_escape_allowing_special_tags(__('The <span class="wcqt_green">main field container</span> can have a fixed width (px) or a percentage width (%). Express the value according to your needs. For example, if you need a fixed width of 200 pixel, enter <strong>200px</strong>. If you need a percentage of 20, enter <strong>20%</strong>', 'woocommerce-quote'), $allowed_tags);?></p>
						<input type="text" name="wcqt_field_options[<?php echo $field_id ?>][main_container][width]" value="<?php echo wcqt_get_value_if_set($field_data, array('main_container', 'width'), "");?>" placeholder="<?php esc_html_e('Example: 200px, 20%, etc', 'woocommerce-quote'); ?>"></input>
				
					</div>
					
					<div class="half_block_fixed_container">
						<label class="wcqt_already_uploaded_message_label"><?php esc_html_e('Text to show after the upload has been completed (HTML code permitted)', 'woocommerce-quote'); ?></label>
						<p><?php echo wp_kses(__('This text will be displayed after an upload has completed', 'woocommerce-quote'), $allowed_tags);?></p>
						<?php foreach($langs as $lang_data): ?>
								<div class="wcqt_description_container">
								<?php if($lang_data['country_flag_url'] != "none"): ?>
									<img src=<?php esc_attr_e($lang_data['country_flag_url']); ?> /><label class="wcqt_label"> <?php esc_attr_e($lang_data['language_code']); ?></label>
								<?php endif; ?>
								<textarea  class="upload_description"  rows="5" cols="80" name="wcqt_field_options[<?php echo $field_id ?>][message_already_uploaded][<?php echo $lang_data['language_code']; ?>]" placeholder="<?php esc_attr_e('This message is displayed after file description only if a file have been uploaded (you can use HTML code)', 'woocommerce-quote'); ?>"><?php echo wcqt_get_value_if_set($field_data , array('message_already_uploaded', $lang_data['language_code']), esc_html__('Upload completed, thank you!','woocommerce-quote') )?></textarea>
						</div>
						<?php endforeach; ?>
					</div>
					
					
					
				
					<div class="wcqt_section_header_container">
						<h3 class="tab-title"><?php esc_html_e('Single/Multiple files upload & size restriction', 'woocommerce-quote');?></h3>
					</div>
					
					<label class="option_label"  ><?php esc_html_e('Enable multiple files upload per single field?', 'woocommerce-quote');?></label>
					<label class="switch">	
						<input type="checkbox"  name="wcqt_field_options[<?php echo $field_id ?>][enable_multiple_uploads_per_field]" value="true" class="wcqt_multiple_files_upload_checkbox master_option" data-related-id="multiple_files_<?php echo $field_id ?>" data-id="<?php echo $field_id ?>" <?php checked(wcqt_get_value_if_set($field_data, 'enable_multiple_uploads_per_field', "false"), "true"); ?> ></input>
						<span class="slider"></span>
					</label>
					
					<div  id="wcqt_single_file_upload_options_container_<?php echo $field_id ?>" data-id="<?php echo $field_id ?>" class="wcqt_single_file_upload_options_container ">
						
						<div class="half_block_container">
							<label class="option_label wcqt_required"><?php esc_html_e('Min file size (MB) limit', 'woocommerce-quote');?></label>
							<p><?php esc_html_e('Leave 0 for no limits. In case of multiple files upload field, each uploaded file size cannot be greater of the specified value.', 'woocommerce-quote');?></p>
							<input type="number" min="0"  step="0.01" name="wcqt_field_options[<?php echo $field_id ?>][min_size]" value="<?php echo wcqt_get_value_if_set($field_data, 'min_size', 0);?>" required></input>
						</div>
						<div class="half_block_container">
							<label class="option_label wcqt_required"><?php esc_html_e('Max file size (MB) limit', 'woocommerce-quote');?></label>
							<p><?php esc_html_e('Leave 0 for no limits. In case of multiple files upload field, each uploaded file size cannot be greater of the specified value.', 'woocommerce-quote');?></p>
							<input type="number" min="0"  step="0.01" name="wcqt_field_options[<?php echo $field_id ?>][max_size]" value="<?php echo wcqt_get_value_if_set($field_data, 'max_size', 0);?>" required></input>
						</div>
					</div>
					
					<div id="wcqt_multiple_files_upload_options_container_<?php echo $field_id ?>" data-id="<?php echo $field_id ?>" class="wcqt_multiple_files_upload_options_container master_related_multiple_files_<?php echo $field_id ?> wcqt_master_related <?php if(!wcqt_get_value_if_set($field_data, 'enable_multiple_uploads_per_field', false)) echo 'wcqt_hidden'; ?>">	
						
						<div class="wcqt_standard_bordered_box">
							<h4><?php esc_html_e('Size sum restriction', 'woocommerce-quote');?></h4>
							<div class="half_block_container">
								<label class="wcqt_required"><?php esc_html_e('Min file sizes sum limit (MB)', 'woocommerce-quote');?></label>
								<p><?php echo  wp_kses(__('Leave 0 for no limit. The <strong>sum of the uploaded file sizes</strong> cannot be lesser of the following value.', 'woocommerce-quote'), $allowed_tags); ?></p>
								<input type="number" min="0" step="0.01" name="wcqt_field_options[<?php echo $field_id ?>][multiple_files_min_size_sum]" value="<?php echo wcqt_get_value_if_set($field_data, 'multiple_files_min_size_sum', 0) ?>"  required></input>
							</div>	
							<div class="half_block_container">
								<label  class="wcqt_required"><?php esc_html_e('Max file sizes sum limit (MB)', 'woocommerce-quote');?></label>
								<p><?php echo  wp_kses(__('Leave 0 for no limit. The <strong>sum of the uploaded file sizes</strong> cannot be greater of than following value.', 'woocommerce-quote'), $allowed_tags); ?></p>
								<input type="number" min="0" step="0.01" name="wcqt_field_options[<?php echo $field_id ?>][multiple_files_max_size_sum]" value="<?php echo wcqt_get_value_if_set($field_data, 'multiple_files_max_size_sum', 0); ?>"  required></input>
							</div>
						</div>
						
						
						<div class="wcqt_standard_bordered_box">
							<h4><?php esc_html_e('Quantity restriction', 'woocommerce-quote');?></h4>
							<p><?php wp_kses(__('Click on the <i>Upload files Configurator -> Options</i> menu to enable the special <strong>Enable quantity selection</strong> option that allows your customers to specify a quantity value for each uploaded file.', 'woocommerce-quote'), $allowed_tags);?></p>
							<div class="half_block_container">
								<label class="wcqt_required"><?php esc_html_e('Minimum number of files that can uploaded', 'woocommerce-quote');?></label>
								<p><?php  wp_kses(__('Leave 0 for no limits. This option will work <strong>ONLY</strong> if the <strong>Multiple files upload per single field</strong> option has been enabled','woocommerce-quote'), $allowed_tags); ?></p>
								<input type="number"  min="0" name="wcqt_field_options[<?php echo $field_id ?>][multiple_uploads_minimum_required_files]" value="<?php echo wcqt_get_value_if_set($field_data, 'multiple_uploads_minimum_required_files', 0); ?>" required></input>
							</div>
							<div class="half_block_container">
								<label  class="wcqt_required"><?php esc_html_e('Max number of files that can be uploaded', 'woocommerce-quote');?></label>
								<p><?php  wp_kses(__('Leave 0 for no limits. This option will work <strong>ONLY</strong> if the <strong>Multiple files upload per single field</strong> option has been enabled','woocommerce-quote'), $allowed_tags); ?></p>
								<input type="number"  min="0"  name="wcqt_field_options[<?php echo $field_id ?>][multiple_uploads_max_files]" value="<?php echo wcqt_get_value_if_set($field_data, 'multiple_uploads_max_files', 0) ?>"   required></input>
							</div>
						</div>
					</div>	

					
					
					<div class="wcqt_section_header_container">
						<h3 class="tab-title"><?php _e('User role', 'woocommerce-quote');?></h3>
					</div>
					<p class="section_description"><?php _e('<strong>Leave unselected to leave the upload field visible for all.</strong> Selecting at least one role will make the upload field to be visible/unvisible to that role. To allow not logged user to perform the upload, use the <strong>Anonymous upload</strong> option you find on top of the page.', 'woocommerce-quote');?></p>
					<label class="option_label"><?php _e('Visibility type', 'woocommerce-quote');?></label>		
					<select  class="upload_type"  name="wcqt_field_options[<?php echo $field_id ?>][roles_policy]">
					  <option value="allow" <?php selected(wcqt_get_value_if_set($field_data, 'roles_policy', "allow"), "allow"); ?>><?php _e('Allow for selected roles', 'woocommerce-quote');?></option>
					  <option value="deny" <?php selected(wcqt_get_value_if_set($field_data, 'roles_policy', "allow"), "deny"); ?>><?php _e('Deny for selected roles', 'woocommerce-quote');?></option>
					</select>
					
					<label class="option_label"><?php _e('Select roles', 'woocommerce-quote');?></label>	
					<?php foreach($wcqt_user_model->get_all_user_roles() as $role_code => $role_name): ?>
							<label style="font-weight:normal;"><input type="checkbox" <?php checked(wcqt_get_value_if_set($field_data, array('roles', $role_code), false)); ?> name="wcqt_field_options[<?php echo $field_id ?>][roles][<?php echo $role_code; ?>]" value="1"><?php echo $role_name['name'] ?></label>
					<?php endforeach; ?>
						<!-- <label style="font-weight:normal;"><input type="checkbox" <?php echo checked(wcqt_get_value_if_set($field_data, array('roles', 'not_logged'), false)); ?> name="wcqt_field_options[<?php echo $field_id ?>][roles][not_logged]" value="1"><?php _e('Guest (<strong>Not logged user</strong>)', 'woocommerce-quote');?></label> -->
					
					
					
				</div>
			</div>
		</div>
		<?php 
		endforeach; //foreach $fields_data
	}

}
?>