<?php  
namespace WCQT\classes\com;

class InputField
{
	public function __construct()
	{
		
	}
	
	public function get_select_labels_and_values($select_data, $lang, $empty_value = false)
	{
		global $wcqt_wpml_model;
		
		$options = isset($select_data[$lang]) ? $select_data[$lang] : "";
		$options = $options == "" && isset($select_data[$lang]) ? $select_data[$lang] :$options;
		$options = trim($options);
		
		$options = $options != "" ? explode(PHP_EOL, $options) : array();
		if(empty($options))
			return $options;
		
		try{
			$label_and_values = $empty_value ? array("" => "") : array();
			foreach((array)$options as $option)
			{
				$tmp_result = explode(":", $option);
				$label_and_values[trim($tmp_result[0])] = trim($tmp_result[1]);
			}
		}catch(Exception  $e){return array();}
		return $label_and_values;
	}
	public function get_value_by_type($raw_value, $type)
	{
		global $wcqt_time_model;
		$value = $raw_value;
		
		
		switch($type)
		{
			case 'date': $value = $wcqt_time_model->get_date_according_wordprerss_settings($raw_value);
			break;
			case 'time': $value = $wcqt_time_model->get_time_according_wordprerss_settings($raw_value);
			break;
			case 'multiselect':
			case 'select': $value = is_array($value) ? implode($value) : str_replace(",", ", ", $raw_value);
			break; 
			case 'checkbox': $value = $raw_value == 'true' ? esc_html('Yes', 'woocommerce-quote') : esc_html('No', 'woocommerce-quote');
			break; 
		}
		
		return $value;
	}
}
?>