<?php 
namespace WCQT\classes\com;

class User
{
	function __construct()
	{
		
	}
	public function can_request_a_quote()
	{
		global $wcqt_option_model, $wcqt_user_model;
		$options = $wcqt_option_model->get_options();
		
		$user_roles = wcqt_get_value_if_set($options, array('roles'), array());
		return  $wcqt_user_model->belongs_to_seleceted_roles($user_roles);
	}
	public function get_all_user_roles()
	 {
		 global $wp_roles;
		 return $wp_roles->roles;
	 }
	 public function get_current_user_roles()
	{
		$user = wp_get_current_user();
		return $user->roles;
	}
	public function belongs_to_seleceted_roles($selected_roles, $user_role_restriction_type = "allow")
	{
		$current_user_role = $this->get_current_user_roles();
		
		$current_user_role = empty($current_user_role) ? array('not_logged') : $current_user_role;
		$user_roles = array();
		foreach((array)$selected_roles as $role_name => $value)
			$selected_roles [$role_name] = $role_name;
		foreach((array)$current_user_role as $index => $role_name)
			$user_roles [$role_name] = $role_name;
		
		return ($user_role_restriction_type == 'allow' && array_intersect($user_roles,$selected_roles)) ||
		       ($user_role_restriction_type == 'deny' && !array_intersect($user_roles,$selected_roles)) ||
		       empty($selected_roles) ? true : false;
	}
	public function get_userdata($user_id)
	{
		return get_userdata($user_id);
	}
	public function get_profile_value($field_name)
	{
		$result = array('value'=> "", "state_value" => "");
		
		if(!$field_name || !get_current_user_id())
			return $result;
		
		$customer = new \WC_Customer(get_current_user_id());
		$result = array('value'=> "", "state_value" => "");
		$method_name = "get_".$field_name;
		if(is_callable( array( $customer, $method_name ) ))
		{
			switch ($field_name):
				case "billing_country": $result['value'] = $customer->get_billing_country(); $result['state_value'] = $customer->get_billing_state();
				break;
				case "shipping_country": $result['value'] = $customer->get_shipping_country(); $result['state_value'] = $customer->get_shipping_state();
				break;
				default: $result['value'] = $customer->$method_name();
				break;
			endswitch;
			
		}
		
		return $result;
	}
}
?>