<?php  
namespace WCQT\classes\frontend;

class MyAccountPage
{
	var $quotes_endpoint = "quotes";
	var $view_quote_endpoint = "view-quote";
	var $is_quote_page =  false;
	public function __construct()
	{
		add_filter('woocommerce_account_menu_items', array(&$this,'add_quotes_to_menu'));
		add_filter('woocommerce_account_menu_item_classes', array(&$this,'manage_quote_menu_voice_classes'), 10, 2);
		//Endpoint management
		add_action( 'init', array($this,'add_custom_endpoints') );
		add_filter( 'query_vars', array(&$this,'add_end_point_to_query_vars'), 0 );
		add_filter( 'woocommerce_account_orders_columns',  array($this,'remove_total_column') );
	}
	function remove_total_column($columns)
	{
		if($this->is_quote_page)
			unset($columns["order-total"]);
		return $columns;
	}
	
	public function add_custom_endpoints() 
	{
		global $wcqt_option_model;
		$options = $wcqt_option_model->get_options();
		
		$this->quotes_endpoint = wcqt_get_value_if_set($options, array('my_account', 'endpoint', 'quotes_list'), $this->quotes_endpoint);
		$this->view_quote_endpoint = wcqt_get_value_if_set($options, array('my_account', 'endpoint', 'quote_details'), $this->view_quote_endpoint);
		add_rewrite_endpoint( $this->quotes_endpoint, EP_ROOT | EP_PAGES );
		add_rewrite_endpoint( $this->view_quote_endpoint, EP_ROOT | EP_PAGES );
		
		//handler 
		add_action( 'woocommerce_account_'.$this->quotes_endpoint.'_endpoint', array($this,'render_quotes_table_page'), 10, 1 );
		add_action( 'woocommerce_account_'.$this->view_quote_endpoint.'_endpoint', array($this,'render_view_quote_page'), 10, 1 );
	
	}
	public function add_end_point_to_query_vars( $vars ) 
	{
		$quotes_area_endpoint =  $this->quotes_endpoint;
		$view_quote_endpoint =  $this->view_quote_endpoint;
		$vars[] = $quotes_area_endpoint;
		$vars[] = $view_quote_endpoint;
		return $vars;
	}
	public function add_quotes_to_menu($items)
	{
		global $wcqt_option_model, $wcqt_wpml_model;
		
		wp_enqueue_style('wcqt-my-account', WCQT_PLUGIN_PATH.'/css/frontend/my-account-page.css');		
		$options = $wcqt_option_model->get_options();
		$current_lang = $wcqt_wpml_model->get_current_language();
		$menu_voice = wcqt_get_value_if_set($options, array('my_account', 'menu_title', $current_lang), esc_html__("Quotes", 'woocommerce-quote'));
		
		$quotes_area_endpoint =  $this->quotes_endpoint;
		$logout = $items['customer-logout'];
		unset( $items['customer-logout'] );
		$items[$quotes_area_endpoint] = $menu_voice;
		$items['customer-logout'] = $logout;
		return $items;
	}
	public function manage_quote_menu_voice_classes($classes, $endpoint)
	{
		global $wp;
		if($endpoint == 'quotes' && ( isset( $wp->query_vars['view-quote'] )))
		{
			$classes[] = "is-active";
		}
		return $classes;
	}
	public function render_quotes_table_page($current_page)
	{
		global $wcqt_order_model;
		$this->is_quote_page = true;
		$current_page = !$current_page ? 1 : intval($current_page);
		$quotes = $wcqt_order_model->get_customer_quotes(get_current_user_id(), true, $current_page);
		$has_quotes = count($quotes->orders) > 0;
		
		wp_enqueue_style('wcqt-quote-table', WCQT_PLUGIN_PATH.'/css/frontend/quote-table-page.css');	
		
		if(file_exists ( get_theme_file_path()."/woocommerce-quote/frontend/my-account/quote-table.php" ))
			include get_theme_file_path()."/woocommerce-quote/frontend/my-account/quote-table.php";
		else
			include WCQT_PLUGIN_ABS_PATH."/templates/frontend/my-account/quote-table.php"; 
	}
	public function render_view_quote_page($order_id)
	{
		global $wp, $wcqt_order_model;
		
		//Reject order
		if (
			isset( $_GET['wcqt_reject'] ) &&
			isset( $_GET['order_key'] ) &&
			( isset( $_GET['_wpnonce'] ) && wp_verify_nonce( wp_unslash( $_GET['_wpnonce'] ), 'wcqt-view-quote-page-security' ) ) 
		)
		{
			wc_nocache_headers();
			$order_key        = wp_unslash( $_GET['order_key'] ); // phpcs:ignore WordPress.Security.ValidatedSanitizedInput.InputNotSanitized
			$order_id         = absint( $_GET['wcqt_reject'] );
			$order            = wc_get_order( $order_id );
			if($order_key == $order->get_order_key())
				$wcqt_order_model->reject_quote($order);
		}
		
		$order =  wc_get_order($order_id);
		if(!$order)
			return;
		$has_been_accepted = $order->has_status('accepted-quote');
		$current_url = home_url( $wp->request );
		wp_enqueue_style('wcqt-view-quote', WCQT_PLUGIN_PATH.'/css/frontend/view-quote-page.css');	
		
		if(file_exists ( get_theme_file_path()."/woocommerce-quote/frontend/my-account/view-quote.php" ))
			include get_theme_file_path()."/woocommerce-quote/frontend/my-account/view-quote.php";
		else
			include WCQT_PLUGIN_ABS_PATH."/templates/frontend/my-account/view-quote.php"; 
	}
	
}
?>