<?php  
namespace WCQT\classes\frontend;

class ProductPage
{
	public function __construct()
	{
		//Add to cart button management
		//no need: add_filter('woocommerce_product_single_add_to_cart_text',array($this,'replace_add_to_cart_text_on_product_page'),99, 2); 
		 
		 add_action('init', array( $this, 'init'));
		 add_filter('woocommerce_before_single_product', array($this, 'woocommerce_before_single_product'));
	}
	function woocommerce_before_single_product()
	{
		global $wcqt_option_model, $product, $wcqt_wpml_model, $wcqt_product_model;
		
		$options = $wcqt_option_model->get_options();
		$current_lang = $wcqt_wpml_model->get_current_language();
		$target_url = get_page_link(wcqt_get_value_if_set($options, array('general', "quote_page_id"), ""));
		wp_register_script( 'wcqt-product-page', WCQT_PLUGIN_PATH.'/js/frontend/product-page.js', array('jquery') );

		$js_data = array( 
						'ajax_url' => admin_url( 'admin-ajax.php' ),
						'security' => wp_create_nonce('wcqt_product_page_security'),
						'is_cart_fragments_js_enqueued' => wp_script_is('wc-cart-fragments') ? "true" : "false",
						'quote_page_url' => $target_url,
						'add_to_cart_txt' => $product->single_add_to_cart_text(),
						'is_variable' => $product->is_type('simple') ? 'no' : 'yes',
						'add_to_quote_txt' => wcqt_get_value_if_set($options, array('texts', 'add_to_quote_button', $current_lang), esc_html__("Add to quote", 'woocommerce-quote')),
						'quotable_variations' => $wcqt_product_model->quotable_variations($product), //false if there aren't only some quotable variations
						'can_be_purchased' => wcqt_get_value_if_set($options, array('general', 'show_add_to_cart_button'), false) == 'true' ? 'true' : 'false',
						'add_to_cart_button_template' => '<button type="submit" class="single_add_to_cart_button button alt'.esc_attr( wc_wp_theme_get_element_class_name( "button" ) ? " " . wc_wp_theme_get_element_class_name("button" ) : "" ).'">'.$product->single_add_to_cart_text().'</button>',
						'add_to_quote_button_template' => '<button type="submit" name="add-to-quote-product-page" value="%s" class="single_add_to_quote_button single_add_to_cart_button button alt'.esc_attr( wc_wp_theme_get_element_class_name( "button" ) ? " " . wc_wp_theme_get_element_class_name("button" ) : "" ).'">'.wcqt_get_value_if_set($options, array('texts', 'add_to_quote_button', $current_lang), esc_html__("Add to quote", 'woocommerce-quote')).'</button>'
					);
		wp_localize_script('wcqt-product-page', 'wcqt_product_page', $js_data);
		wp_enqueue_script( 'wcqt-product-page');
		
	}
	//Product page "add to cart" button management
	function init()
	{
		remove_action( 'woocommerce_simple_add_to_cart', 'woocommerce_simple_add_to_cart', 30 );  
		//master: remove_action( 'woocommerce_variable_add_to_cart', 'woocommerce_variable_add_to_cart', 30 ); 
		remove_action( 'woocommerce_single_variation', 'woocommerce_single_variation_add_to_cart_button', 20 ); 
		remove_action( 'woocommerce_grouped_add_to_cart', 'woocommerce_grouped_add_to_cart', 30 ); 
		remove_action( 'woocommerce_external_add_to_cart', 'woocommerce_external_add_to_cart', 30 ); 
		
		
		add_action( 'woocommerce_simple_add_to_cart', array( $this,'add_single_product_page_simple_add_to_cart_link' ), 30);
		//master: add_action( 'woocommerce_variable_add_to_cart', array( $this,'add_single_product_page_variable_add_to_cart_link' ), 30);
		add_action( 'woocommerce_single_variation',  array( $this,'add_single_variation_page_simple_add_to_cart_link'), 20 );
		add_action( 'woocommerce_grouped_add_to_cart', array( $this,'add_single_product_page_grouped_add_to_cart_link' ), 30);
		add_action( 'woocommerce_external_add_to_cart', array( $this,'add_single_product_page_external_add_to_cart_link' ), 30);
	}
	function replace_add_to_cart_text_on_product_page($original_text, $product)
	{
		global $wcqt_product_model, $wcqt_user_model, $wcqt_option_model, $wcqt_wpml_model;
		$options = $wcqt_option_model->get_options();
		$products = $wcqt_product_model->get_quotable_products_list();
		$current_lang = $wcqt_wpml_model->get_current_language();
		if($display_add_to_quote_button && ($products == "always" || in_array($product->get_id(), $products)))
		{
			return wcqt_get_value_if_set($options, array('texts', 'add_to_quote_button', $current_lang), esc_html__("Add to quote", 'woocommerce-quote'));
		}
		else 
			return $original_text;
	}
	//Management of the remove "add to cart button" on the product page
	public function add_single_product_page_simple_add_to_cart_link()
	{
		$this->add_single_product_page_add_to_cart_link('simple');
	}
	public function add_single_product_page_variable_add_to_cart_link()
	{
		$this->add_single_product_page_add_to_cart_link('variable');
	}
	public function add_single_variation_page_simple_add_to_cart_link()
	{
		$this->add_single_product_page_add_to_cart_link('variation');
	}
	public function add_single_product_page_grouped_add_to_cart_link()
	{
		$this->add_single_product_page_add_to_cart_link('grouped');
	}
	public function add_single_product_page_external_add_to_cart_link()
	{
		$this->add_single_product_page_add_to_cart_link('external');
	}
	
	public function add_single_product_page_add_to_cart_link($add_to_cart_code = 'simple')
	{
		global $product,  $wcqt_product_model, $wcqt_option_model, $wcqt_wpml_model;
		
		$options = $wcqt_option_model->get_options();
		$add_to_cart_code = $add_to_cart_code ? $add_to_cart_code : "simple";
		
		//Stock management: for products that can be added to quote, the stock management is temporarly disabled
		$original_stock_status = $product->get_stock_status();
		$products = $wcqt_product_model->get_quotable_products_list();
		$current_lang = $wcqt_wpml_model->get_current_language();
		$quotable_products_can_be_purchased = wcqt_get_value_if_set($options, array('general', 'show_add_to_cart_button'), false) == 'true';
		$is_quotable = false;
		
		if($products == "always" || in_array($product->get_id(), $products))
		{
			$product->set_stock_status();
			$is_quotable = true;
		}
		
		$enable_add_to_cart_button = wcqt_get_value_if_set($options, array('general', 'show_add_to_cart_button'), false) == 'true';
		
		
		switch($add_to_cart_code)
			{
				case 'simple': if(file_exists ( get_theme_file_path()."/wcqt/frontend/product-page/simple.php" ))
									include get_theme_file_path()."/wcqt/frontend/product-page/simple.php";
								else
									include WCQT_PLUGIN_ABS_PATH."/templates/frontend/product-page/simple.php";
								break;
				case 'variable': woocommerce_variable_add_to_cart(); break; //not used
				case 'variation':if(file_exists ( get_theme_file_path()."/wcqt/frontend/product-page/variation-add-to-cart-button.php" ))
									include get_theme_file_path()."/wcqt/frontend/product-page/variation-add-to-cart-button.php";
								else
									include WCQT_PLUGIN_ABS_PATH."/templates/frontend/product-page/variation-add-to-cart-button.php";
								break;
				case 'grouped': if(file_exists ( get_theme_file_path()."/wcqt/frontend/product-page/grouped.php" ))
									include get_theme_file_path()."/wcqt/frontend/product-page/grouped.php";
								else
									include WCQT_PLUGIN_ABS_PATH."/templates/frontend/product-page/grouped.php";
								break;
				case 'external': if(file_exists ( get_theme_file_path()."/wcqt/frontend/product-page/external.php" ))
									include get_theme_file_path()."/wcqt/frontend/product-page/external.php";
								else
									include WCQT_PLUGIN_ABS_PATH."/templates/frontend/product-page/external.php";
								break;
			
			}
	}
	public function wc_add_to_cart_form() 
	{
		wc_pb_template_add_to_cart();
	}
	public function booking_add_to_cart()
	{
		global $product;
		$booking_form = new WC_Booking_Form( $product );
		wc_get_template( 'single-product/add-to-cart/booking.php', array( 'booking_form' => $booking_form ), 'woocommerce-bookings', WC_BOOKINGS_TEMPLATE_PATH );
	}
	public function woosb_add_to_cart_form() 
	{

		global $product;

		if ( $product->has_variables() ) {

			wp_enqueue_script( 'wc-add-to-cart-variation' );

		}
		
		if(file_exists ( get_theme_file_path()."/wcqt/frontend/product-page/product-bundle-add-to-cart.php" ))
			include get_theme_file_path()."/wcqt/frontend/product-page/product-bundle-add-to-cart.php";
		else
			include WCQT_PLUGIN_ABS_PATH."/templates/frontend/product-page/product-bundle-add-to-cart.php";

		wc_get_template( 'single-product/add-to-cart/simple.php' );

	}
}
?>