<?php 
$langs =  $wcqt_wpml_model->get_langauges_list();
?>
<tr id="wcqt-input-field-<?php echo $input_field_id; ?>" class="field-row" data-id="<?php echo $input_field_id; ?>">
	<td><?php esc_html_e('Date','woocommerce-quote'); ?></td>
	<td id="wcqt-td-label-<?php echo $input_field_id; ?>"><?php esc_html_e(wcqt_get_value_if_set($field_data, array('label', $wcqt_wpml_model->get_current_language()), ""));  ?></td>
	<td id="wcqt-td-connects_to-<?php echo $input_field_id; ?>"><?php esc_html_e(wcqt_get_value_if_set($field_data, array('connects_to'), ""));  ?></td>
	<td id="wcqt-td-required-<?php echo $input_field_id; ?>"><?php echo wcqt_get_value_if_set($field_data, array('required'), "") == "true" ? esc_html_e('Yes','woocommerce-quote') : esc_html_e('No','woocommerce-quote');  ?></td>
	<td id="wcqt-td-disabled-<?php echo $input_field_id; ?>"><?php echo wcqt_get_value_if_set($field_data, array('disabled'), "") == "true" ? esc_html_e('Yes','woocommerce-quote') : esc_html_e('No','woocommerce-quote');  ?></td>
	<td class="table-actions">
		<a href="#" >
			<span class="dashicons dashicons-move move-field wcqt-move-button disable_during_animation" data-id="<?php echo $input_field_id; ?>" ></span>
		</a>
		<a href="#" >
			<span class="dashicons dashicons-edit expand-field wcqt-action-button disable_during_animation" data-id="<?php echo $input_field_id; ?>" data-effect="mfp-zoom-in" href="#wcqt_input_field_container_<?php echo $input_field_id; ?>"></span>
		</a>
		<a href="#" >
			<span class="dashicons dashicons-trash delete-field wcqt-action-button disable_during_animation" data-id="<?php echo $input_field_id; ?>" ></span>
		</a>
		
		<!-- popup content content -->
		<div class="wcqt_input_field_container white-popup mfp-with-anim mfp-hide" id="wcqt_input_field_container_<?php echo $input_field_id; ?>" data-id="<?php echo $input_field_id; ?>">
			<div class="wcqt_input_field_options_container " id="wcqt_input_field_options_container_<?php echo $input_field_id; ?>">
				<form method="post" action="" class="wcqt-input-field-form" data-id="<?php echo $input_field_id; ?>">
				<input type="hidden" value="<?php echo $type; ?>"  name="wcqt_options[input_fields][<?php echo $input_field_id; ?>][type]"></input>
				<table class="input-field-form-table">
					<tbody>
						<?php foreach($langs as $language_code => $lang_data): ?>
						<tr>
							<th class="label"><?php esc_html_e('Label ','woocommerce-quote');?>
							<?php if($lang_data['country_flag_url'] != "none"): ?>
										<br/><img src=<?php echo $lang_data['country_flag_url']; ?> /> <?php echo $lang_data['default_locale']; ?><br/>
									<?php endif; ?>
							</th>
							<td>
								<input type="text" 
										   name="wcqt_options[input_fields][<?php echo $input_field_id; ?>][label][<?php echo $lang_data['language_code']; ?>]" 
										   placeholder="<?php esc_html_e('Label','woocommerce-quote');?>"
										   value="<?php echo esc_attr(wcqt_get_value_if_set($field_data, array('label', $lang_data['language_code']), "")); ?>"
										   required ="required">
									</input>
							</td>
						</tr>
						<?php endforeach; ?>
						
						<tr>
							<th class="label"><?php esc_html_e('Connects to', 'woocommerce-quote');?></th>
							<td>
								<select name='wcqt_options[input_fields][<?php echo $input_field_id; ?>][connects_to]'>
									<option value="none"><?php esc_html_e('None', 'woocommerce-quote');?></option>
									<?php foreach ($wcqt_order_model->get_order_fields_list() as $field_id => $order_field_data): ?>
										<option value="<?php echo $field_id; ?>" <?php selected(wcqt_get_value_if_set($field_data, 'connects_to', "none"), $field_id); ?>><?php echo $order_field_data['type']." ".$order_field_data['label'];?></option>
									<?php endforeach; ?>
								</select>
								<div class="description"><?php esc_html_e('Once the quote is placed, the connected Order field will be filled with this field value','woocommerce-quote');?></div>
							</td>
						</tr>
						<tr>
							<th class="label"><?php esc_html_e('Autofill', 'woocommerce-quote');?></th>
							<td>
								<label class="switch">
									<input type="checkbox" name="wcqt_options[input_fields][<?php echo $input_field_id; ?>][autofill]" value="true" <?php checked(wcqt_get_value_if_set($field_data, 'autofill', false), "true") ?> ></input>
									<span class="slider"></span>
								</label>
								<div class="description"><?php esc_html_e('The field will be auto-filled with user billing/shipping data. This will work only if the "Connect to" option has been enabled and the user is not a guest.','woocommerce-quote');?></div>
							</td>
						</tr>
						<tr>
							<th class="label"><?php esc_html_e('Position / Size', 'woocommerce-quote');?></th>
							<td>
								<select name='wcqt_options[input_fields][<?php echo $input_field_id; ?>][position]'>
									<option value="wide"  <?php selected(wcqt_get_value_if_set($field_data, 'position', "wide"), "wide"); ?>><?php esc_html_e('Wide (whole row)', 'woocommerce-quote');?></option>
									<option value="first" <?php selected(wcqt_get_value_if_set($field_data, 'position', "wide"), "first"); ?>><?php esc_html_e('First (first half)', 'woocommerce-quote');?></option>
									<option value="last"  <?php selected(wcqt_get_value_if_set($field_data, 'position', "wide"), "last"); ?> ><?php esc_html_e('Last (second half)', 'woocommerce-quote');?></option>
								</select>
								<div class="description"><?php esc_html_e('Position and size of the field','woocommerce-quote');?></div>
							</td>
						</tr>
						
						<tr>
							<th class="label"><?php esc_html_e('Required', 'woocommerce-quote');?></th>
							<td>
								<label class="switch">
									<input type="checkbox" name="wcqt_options[input_fields][<?php echo $input_field_id; ?>][required]" value="true" <?php checked(wcqt_get_value_if_set($field_data, 'required', false), "true") ?> ></input>
									<span class="slider"></span>
								</label>
								<div class="description"><?php esc_html_e('Set if the input field has to be mandatory or not','woocommerce-quote'); ?></div>
							</td>
						</tr>
						
						<tr>
							<th class="label"><?php esc_html_e('Min date', 'woocommerce-quote');?></th>
							<td>
								<input type="text" 
								   name="wcqt_options[input_fields][<?php echo $input_field_id; ?>][min_date]" 
								   placeholder=""
								   class="wcqt_date_field"
								   value="<?php echo esc_attr(wcqt_get_value_if_set($field_data, array('min_date'), "")); ?>"></input>
								<div class="description"><?php esc_html_e('Set the min selectable date','woocommerce-quote'); ?></div>
							</td>
						</tr>
						
						<tr>
							<th class="label"><?php esc_html_e('Max date', 'woocommerce-quote');?></th>
							<td>
								<input type="text" 
								   name="wcqt_options[input_fields][<?php echo $input_field_id; ?>][max_date]" 
								   placeholder=""
								   class="wcqt_date_field"
								   value="<?php echo esc_attr(wcqt_get_value_if_set($field_data, array('max_date'), "")); ?>"></input>
								<div class="description"><?php esc_html_e('Set the max selectable date','woocommerce-quote'); ?></div>
							</td>
						</tr>
						
						<tr>
							<th class="label"><?php esc_html_e('Days of the week to disable', 'woocommerce-quote');?></th>
							<td>
								<div class="wcqt-day-container">
								<input type="checkbox" 
									   name="wcqt_options[input_fields][<?php echo $input_field_id; ?>][day_to_disable][1]" 
									   value="1"
									   <?php checked(wcqt_get_value_if_set($field_data, array('day_to_disable', 1), false), 1); ?> ><?php esc_html_e('Monday','woocommerce-quote');?></input>
								</div>
								<div class="wcqt-day-container">
								<input type="checkbox" 
									   name="wcqt_options[input_fields][<?php echo $input_field_id; ?>][day_to_disable][2]" 
									   value="2"
									   <?php checked(wcqt_get_value_if_set($field_data, array('day_to_disable', 2), false), 2); ?> ><?php esc_html_e('Tuesday','woocommerce-quote');?></input>
								</div>
								<div class="wcqt-day-container">
								<input type="checkbox" 
									   name="wcqt_options[input_fields][<?php echo $input_field_id; ?>][day_to_disable][3]" 
									   value="3"
									   <?php checked(wcqt_get_value_if_set($field_data, array('day_to_disable', 3), false), 3); ?> ><?php esc_html_e('Wednesday','woocommerce-quote');?></input>
									   
								</div>
								<div class="wcqt-day-container">
								<input type="checkbox" 
									   name="wcqt_options[input_fields][<?php echo $input_field_id; ?>][day_to_disable][4]" 
									   value="4"
									   <?php checked(wcqt_get_value_if_set($field_data, array('day_to_disable', 4), false), 4); ?> ><?php esc_html_e('Thursday','woocommerce-quote');?></input>
								</div>
								<div class="wcqt-day-container">
								<input type="checkbox" 
									   name="wcqt_options[input_fields][<?php echo $input_field_id; ?>][day_to_disable][5]" 
									   value="5"
									   <?php checked(wcqt_get_value_if_set($field_data, array('day_to_disable', 5), false), 5); ?> ><?php esc_html_e('Friday','woocommerce-quote');?></input>
								</div>
								<div class="wcqt-day-container">	 
								<input type="checkbox" 
									   name="wcqt_options[input_fields][<?php echo $input_field_id; ?>][day_to_disable][6]" 
									   value="6"
									   <?php checked(wcqt_get_value_if_set($field_data, array('day_to_disable', 6), false), 6); ?> ><?php esc_html_e('Saturday','woocommerce-quote');?></input>
								</div>
								<div class="wcqt-day-container">	   
								<input type="checkbox" 
									   name="wcqt_options[input_fields][<?php echo $input_field_id; ?>][day_to_disable][7]" 
									   value="7"
									   <?php checked(wcqt_get_value_if_set($field_data, array('day_to_disable', 7), false), 7); ?> ><?php esc_html_e('Sunday','woocommerce-quote');?></input>
								</div>
								<div class="description"><?php esc_html_e('Set which days of the week are unavailable for selection','woocommerce-quote'); ?></div>
							</td>
						</tr>
						
						<tr>
							<th class="label"><?php esc_html_e('Specifc dates to exclude', 'woocommerce-quote');?></th>
							<td>
								<textarea  rows="6" cols="50"
									name="wcqt_options[input_fields][<?php echo $input_field_id; ?>][specific_dates_to_disable]" 
									placeholder=""><?php if(isset($field_data['specific_dates_to_disable'])) echo $field_data['specific_dates_to_disable']; ?></textarea>
								<div class="description"><?php wcqt_html_escape_allowing_special_tags(__('<strong>Guide:</strong> Enter each date on a new line.<br/>Each line rapresent a date and must be expessed in the following format <i>d:m</i>, where <i>d</i> is the day number (1-31) and <i>m</i> is the month number (1-12). Example: <ul><li>24:12</li><li>1:3</li><li>15:2</li></ul>','woocommerce-conditional-checkout-field')); ?></div>
							</td>
						</tr>
						
					</tbody>
				</table>	
				
				<div class="actions-button-container">
					<button class="button button-primary disable_during_animation save-input-field-button" data-id="<?php echo $input_field_id;?>" ><?php esc_html_e('Save', 'woocommerce-quote'); ?></button> 
					<button class="button button-delete button-close-popup disable_during_animation cancel-input-field-button" data-id="<?php echo $input_field_id;?>"><?php esc_html_e('Cancel', 'woocommerce-quote'); ?></button> 
				</div>
				<div class="spinner load_new_input_field_spinner"></div>
				</form>
			</div>
		</div>

	</td>
</tr>