<?php 
$langs =  $wcqt_wpml_model->get_langauges_list();
?>
<tr id="wcqt-input-field-<?php echo $input_field_id; ?>" class="field-row" data-id="<?php echo $input_field_id; ?>">
	<td><?php esc_html_e('Time','woocommerce-quote'); ?></td>
	<td id="wcqt-td-label-<?php echo $input_field_id; ?>"><?php esc_html_e(wcqt_get_value_if_set($field_data, array('label', $wcqt_wpml_model->get_current_language()), ""));  ?></td>
	<td id="wcqt-td-connects_to-<?php echo $input_field_id; ?>"><?php esc_html_e(wcqt_get_value_if_set($field_data, array('connects_to'), ""));  ?></td>
	<td id="wcqt-td-required-<?php echo $input_field_id; ?>"><?php echo wcqt_get_value_if_set($field_data, array('required'), "") == "true" ? esc_html_e('Yes','woocommerce-quote') : esc_html_e('No','woocommerce-quote');  ?></td>
	<td id="wcqt-td-disabled-<?php echo $input_field_id; ?>"><?php echo wcqt_get_value_if_set($field_data, array('disabled'), "") == "true" ? esc_html_e('Yes','woocommerce-quote') : esc_html_e('No','woocommerce-quote');  ?></td>
	<td class="table-actions">
		<a href="#" >
			<span class="dashicons dashicons-move move-field wcqt-move-button disable_during_animation" data-id="<?php echo $input_field_id; ?>"></span>
		</a>
		<a href="#" >
			<span class="dashicons dashicons-edit expand-field wcqt-action-button disable_during_animation" data-id="<?php echo $input_field_id; ?>" data-effect="mfp-zoom-in" href="#wcqt_input_field_container_<?php echo $input_field_id; ?>"></span>
		</a>
		<a href="#" >
			<span class="dashicons dashicons-trash delete-field wcqt-action-button disable_during_animation" data-id="<?php echo $input_field_id; ?>" ></span>
		</a>
		
		<!-- popup content content -->
		<div class="wcqt_input_field_container white-popup mfp-with-anim mfp-hide" id="wcqt_input_field_container_<?php echo $input_field_id; ?>" data-id="<?php echo $input_field_id; ?>">
			<div class="wcqt_input_field_options_container " id="wcqt_input_field_options_container_<?php echo $input_field_id; ?>">
				<form method="post" action="" class="wcqt-input-field-form" data-id="<?php echo $input_field_id; ?>">
				<input type="hidden" value="<?php echo $type; ?>"  name="wcqt_options[input_fields][<?php echo $input_field_id; ?>][type]"></input>
				<table class="input-field-form-table">
					<tbody>
						<?php foreach($langs as $language_code => $lang_data): ?>
						<tr>
							<th class="label"><?php esc_html_e('Label ','woocommerce-quote');?>
							<?php if($lang_data['country_flag_url'] != "none"): ?>
										<br/><img src=<?php echo $lang_data['country_flag_url']; ?> /> <?php echo $lang_data['default_locale']; ?><br/>
									<?php endif; ?>
							</th>
							<td>
								<input type="text" 
										   name="wcqt_options[input_fields][<?php echo $input_field_id; ?>][label][<?php echo $lang_data['language_code']; ?>]" 
										   placeholder="<?php esc_html_e('Label','woocommerce-quote');?>"
										   value="<?php echo esc_attr(wcqt_get_value_if_set($field_data, array('label', $lang_data['language_code']), "")); ?>"
										   required ="required">
									</input>
							</td>
						</tr>
						<?php endforeach; ?>
						
						<tr>
							<th class="label"><?php esc_html_e('Connects to', 'woocommerce-quote');?></th>
							<td>
								<select name='wcqt_options[input_fields][<?php echo $input_field_id; ?>][connects_to]'>
									<option value="none"><?php esc_html_e('None', 'woocommerce-quote');?></option>
									<?php foreach ($wcqt_order_model->get_order_fields_list() as $field_id => $order_field_data): ?>
										<option value="<?php echo $field_id; ?>" <?php selected(wcqt_get_value_if_set($field_data, 'connects_to', "none"), $field_id); ?>><?php echo $order_field_data['type']." ".$order_field_data['label'];?></option>
									<?php endforeach; ?>
								</select>
								<div class="description"><?php esc_html_e('Once the quote is placed, the connected Order field will be filled with this field value','woocommerce-quote');?></div>
							</td>
						</tr>
						<tr>
							<th class="label"><?php esc_html_e('Autofill', 'woocommerce-quote');?></th>
							<td>
								<label class="switch">
									<input type="checkbox" name="wcqt_options[input_fields][<?php echo $input_field_id; ?>][autofill]" value="true" <?php checked(wcqt_get_value_if_set($field_data, 'autofill', false), "true") ?> ></input>
									<span class="slider"></span>
								</label>
								<div class="description"><?php esc_html_e('The field will be auto-filled with user billing/shipping data. This will work only if the "Connect to" option has been enabled and the user is not a guest.','woocommerce-quote');?></div>
							</td>
						</tr>
						
						<tr>
							<th class="label"><?php esc_html_e('Position / Size', 'woocommerce-quote');?></th>
							<td>
								<select name='wcqt_options[input_fields][<?php echo $input_field_id; ?>][position]'>
									<option value="wide"  <?php selected(wcqt_get_value_if_set($field_data, 'position', "wide"), "wide"); ?>><?php esc_html_e('Wide (whole row)', 'woocommerce-quote');?></option>
									<option value="first" <?php selected(wcqt_get_value_if_set($field_data, 'position', "wide"), "first"); ?>><?php esc_html_e('First (first half)', 'woocommerce-quote');?></option>
									<option value="last"  <?php selected(wcqt_get_value_if_set($field_data, 'position', "wide"), "last"); ?> ><?php esc_html_e('Last (second half)', 'woocommerce-quote');?></option>
								</select>
								<div class="description"><?php esc_html_e('Position and size of the field','woocommerce-quote');?></div>
							</td>
						</tr>
						
						<tr>
							<th class="label"><?php esc_html_e('Required', 'woocommerce-quote');?></th>
							<td>
								<label class="switch">
									<input type="checkbox" name="wcqt_options[input_fields][<?php echo $input_field_id; ?>][required]" value="true" <?php checked(wcqt_get_value_if_set($field_data, 'required', false), "true") ?> ></input>
									<span class="slider"></span>
								</label>
								<div class="description"><?php esc_html_e('Set if the input field has to be mandatory or not','woocommerce-quote'); ?></div>
							</td>
						</tr>
						
						<tr>
							<th class="label"><?php esc_html_e('Min date', 'woocommerce-quote');?></th>
							<td>
								<input type="text" 
								   name="wcqt_options[input_fields][<?php echo $input_field_id; ?>][min_time]" 
								   placeholder=""
								   class="wcqt_date_field"
								   value="<?php echo esc_attr(wcqt_get_value_if_set($field_data, array('min_time'), "")); ?>"></input>
								<div class="description"><?php esc_html_e('Set the min selectable time','woocommerce-quote'); ?></div>
							</td>
						</tr>
						
						<tr>
							<th class="label"><?php esc_html_e('Min relative time from now', 'woocommerce-quote');?></th>
							<td>
								<input type="number" 
									   step="1"
									   class="wcqt-half-width" 
									   name="wcqt_options[input_fields][<?php echo $input_field_id; ?>][time_min_offset]" 
									   placeholder="<?php esc_html_e('Leave empty for no min time restriction','woocommerce-quote');?>"
									   value="<?php echo wcqt_get_value_if_set($field_data, array('time_min_offset'), ""); ?>"></input>
								<select name="wcqt_options[input_fields][<?php echo $input_field_id; ?>][time_min_offset_type]" class="wcqt-half-width">
									<option value="second" <?php selected(wcqt_get_value_if_set($field_data, array('time_min_offset_type'), ""), "seconds"); ?>><?php esc_html_e('Second','woocommerce-quote');?></option>
									<option value="minute" <?php selected(wcqt_get_value_if_set($field_data, array('time_min_offset_type'), ""), "minute"); ?>><?php esc_html_e('Minute','woocommerce-quote');?></option>
									<option value="hour" <?php selected(wcqt_get_value_if_set($field_data, array('time_min_offset_type'), ""), "hour"); ?>><?php esc_html_e('Hour','woocommerce-quote');?></option>
								</select>
								<div class="description"><?php esc_html_e('This option overrides the "Min time" option. Leave empty for no restriction. Setting 0, the minimum selectable time will be equal to "now".','woocommerce-quote'); ?></div>
							</td>
						</tr>
						
						<tr>
							<th class="label"><?php esc_html_e('Max date', 'woocommerce-quote');?></th>
							<td>
								<input type="text" 
								   name="wcqt_options[input_fields][<?php echo $input_field_id; ?>][max_time]" 
								   placeholder=""
								   class="wcqt_date_field"
								   value="<?php echo esc_attr(wcqt_get_value_if_set($field_data, array('max_time'), "")); ?>"></input>
								<div class="description"><?php esc_html_e('Set the max selectable time','woocommerce-quote'); ?></div>
							</td>
						</tr>
						
						<tr>
							<th class="label"><?php esc_html_e('Max relative time from now', 'woocommerce-quote');?></th>
							<td>
								<input type="number" 
									   step="1"
									   class="wcqt-half-width" 
									   name="wcqt_options[input_fields][<?php echo $input_field_id; ?>][time_max_offset]" 
									   placeholder="<?php esc_html_e('Leave empty for no min time restriction','woocommerce-quote');?>"
									   value="<?php echo wcqt_get_value_if_set($field_data, array('time_max_offset'), ""); ?>"></input>
								<select name="wcqt_options[input_fields][<?php echo $input_field_id; ?>][time_max_offset_type]" class="wcqt-half-width">
									<option value="second" <?php selected(wcqt_get_value_if_set($field_data, array('time_max_offset_type'), ""), "seconds"); ?>><?php esc_html_e('Second','woocommerce-quote');?></option>
									<option value="minute" <?php selected(wcqt_get_value_if_set($field_data, array('time_max_offset_type'), ""), "minute"); ?>><?php esc_html_e('Minute','woocommerce-quote');?></option>
									<option value="hour" <?php selected(wcqt_get_value_if_set($field_data, array('time_max_offset_type'), ""), "hour"); ?>><?php esc_html_e('Hour','woocommerce-quote');?></option>
								<div class="description"><?php esc_html_e('This option overrides the "Max time" option. Leave empty for no restriction. Setting 0, the minimum selectable time will be equal to "now".','woocommerce-quote'); ?></div>
							</td>
						</tr>
						
					</tbody>
				</table>	
				
				<div class="actions-button-container">
					<button class="button button-primary disable_during_animation save-input-field-button" data-id="<?php echo $input_field_id;?>" ><?php esc_html_e('Save', 'woocommerce-quote'); ?></button> 
					<button class="button button-delete button-close-popup disable_during_animation cancel-input-field-button" data-id="<?php echo $input_field_id;?>"><?php esc_html_e('Cancel', 'woocommerce-quote'); ?></button> 
				</div>
				<div class="spinner load_new_input_field_spinner"></div>
				</form>
			</div>
		</div>

	</td>
</tr>