<?php 
/**
 * New quote email
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/emails/new-quote.php.
 *
 * @version 1.0.0
 */
  
 if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
 /*
 * @hooked WC_Emails::email_header() Output the email header
 */
do_action( 'woocommerce_email_header', $email_heading, $email ); 


if ( $body_content ): 
	echo wp_kses_post( wpautop( wptexturize( $body_content ) ) );
endif; 
?>
<?php

/*
 * @hooked WC_Emails::order_details() Shows the order details table.
 * @hooked WC_Structured_Data::generate_order_data() Generates structured data.
 * @hooked WC_Structured_Data::output_structured_data() Outputs structured data.
 * @since 2.5.0
 */
//no need to trigger do_action( 'woocommerce_email_order_details', $order, $sent_to_admin, $plain_text, $email );

//Order items table
$text_align = is_rtl() ? 'right' : 'left';

do_action( 'woocommerce_email_before_order_table', $order, $sent_to_admin, $plain_text, $email ); ?>

<h2>
	<?php
	if ( $sent_to_admin ) {
		$before = '<a class="link" href="' . esc_url( $order->get_edit_order_url() ) . '">';
		$after  = '</a>';
	} else {
		$before = '';
		$after  = '';
	}
	/* translators: %s: Order ID. */
	echo wp_kses_post( $before . sprintf( __( '[Order #%s]', 'woocommerce-quote' ) . $after . ' (<time datetime="%s">%s</time>)', $order->get_order_number(), $order->get_date_created()->format( 'c' ), wc_format_datetime( $order->get_date_created() ) ) );
	?>
</h2>
<div style="margin-bottom: 40px;">
	<table class="td" cellspacing="0" cellpadding="6" style="width: 100%; font-family: 'Helvetica Neue', Helvetica, Roboto, Arial, sans-serif;" border="1">
		<thead>
			<tr>
				<th class="td" scope="col" style="text-align:<?php echo esc_attr( $text_align ); ?>;"><?php esc_html_e( 'Product', 'woocommerce-quote' ); ?></th>
				<th class="td" scope="col" style="text-align:<?php echo esc_attr( $text_align ); ?>;"><?php esc_html_e( 'Quantity', 'woocommerce-quote' ); ?></th>
			</tr>
		</thead>
		<tbody>
				<?php	
				wc_get_template(
					"emails/order-items-without-price.php",
					apply_filters(
						'woocommerce_email_order_items_args',
						array(
							'order'               => $order,
							'items'               => $order->get_items(),
							'show_download_links' => $order->is_download_permitted() && ! $args['sent_to_admin'],
							'show_sku'            => false,
							'show_purchase_note'  => $order->is_paid() && ! $sent_to_admin,
							'show_image'          => true,
							'image_size'          => array( 32, 32 ),
							'plain_text'          => false,
							'sent_to_admin'       => $sent_to_admin,
						)
					),
					'',
					WCQT_PLUGIN_ABS_PATH . '/templates/'
				);
				//end table content 
		?>
		</tbody>
		<tfoot>
			<?php
			if ( $order->get_customer_note() ) 
			{
				?>
				<tr>
					<th class="td" scope="row" colspan="2" style="text-align:<?php echo esc_attr( $text_align ); ?>;"><?php esc_html_e( 'Note:', 'woocommerce' ); ?></th>
					<td class="td" style="text-align:<?php echo esc_attr( $text_align ); ?>;"><?php echo wp_kses_post( nl2br( wptexturize( $order->get_customer_note() ) ) ); ?></td>
				</tr>
				<?php
			}
			?>
		</tfoot>
	</table>
</div>

<?php do_action( 'woocommerce_email_after_order_table', $order, $sent_to_admin, $plain_text, $email );
//End table

/*
 * @hooked WC_Emails::order_meta() Shows order meta data.
 */
do_action( 'woocommerce_email_order_meta', $order, $sent_to_admin, $plain_text, $email );

/*
 * @hooked WC_Emails::customer_details() Shows customer details
 * @hooked WC_Emails::email_address() Shows email address
 */
do_action( 'woocommerce_email_customer_details', $order, $sent_to_admin, $plain_text, $email );

/**
 * Show user-defined additonal content - this is set in each email's settings.
 */


/*
 * @hooked WC_Emails::email_footer() Output the email footer
 */
do_action( 'woocommerce_email_footer', $email );
 ?>