<?php
/**
 * View Quote
 * @version 1.0
 */

defined( 'ABSPATH' ) || exit;

$notes = $order->get_customer_order_notes();

if(!$has_been_accepted && false):
?>
<h2><?php esc_html_e( 'Quote unavailable', 'woocommerce-quote' ); ?></h2>

<?php return;
endif; ?>
<p>
<?php
printf(
	esc_html__( 'Quote #%1$s was placed on %2$s and is currently %3$s.', 'woocommerce-quote' ),
	'<mark class="order-number">' . $order->get_order_number() . '</mark>', // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
	'<mark class="order-date">' . wc_format_datetime( $order->get_date_created() ) . '</mark>', // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
	'<mark class="order-status">' . wc_get_order_status_name( $order->get_status() ) . '</mark>' // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
);
?>
</p>

<?php if($has_been_accepted): 
	$expiring_data = $wcqt_order_model->get_expiring_date($order);
	if($expiring_data['datetime']): ?>
	<p>
		<?php printf(esc_html__( 'The quote will expire on %s.', 'woocommerce-quote' ),
					 '<mark class="order-date">' .$expiring_data['datetime'] . '</mark>'); ?>
	<p>
	<? endif; ?>
<? endif; ?>

<?php if ( $notes ) : ?>
	<h2><?php esc_html_e( 'Quote updates', 'woocommerce-quote' ); ?></h2>
	<ol class="woocommerce-QuoteUpdates commentlist notes">
		<?php foreach ( $notes as $note ) : ?>
		<li class="woocommerce-QuoteUpdate comment note">
			<div class="woocommerce-QuoteUpdate-inner comment_container">
				<div class="woocommerce-QuoteUpdate-text comment-text">
					<p class="woocommerce-QuoteUpdate-meta meta"><?php echo date_i18n( esc_html__( 'l jS \o\f F Y, h:ia', 'woocommerce-quote' ), strtotime( $note->comment_date ) ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?></p>
					<div class="woocommerce-QuoteUpdate-description description">
						<?php echo wpautop( wptexturize( $note->comment_content ) ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
					</div>
					<div class="clear"></div>
				</div>
				<div class="clear"></div>
			</div>
		</li>
		<?php endforeach; ?>
	</ol>
	
<?php endif; 

$order_items           = $order->get_items( apply_filters( 'woocommerce_purchase_order_item_types', 'line_item' ) );
$show_purchase_note    = $order->has_status( apply_filters( 'woocommerce_purchase_note_order_statuses', array( 'completed', 'processing' ) ) );
$show_customer_details = is_user_logged_in() && $order->get_user_id() === get_current_user_id();
$downloads             = $order->get_downloadable_items();
$show_downloads        = $order->has_downloadable_item() && $order->is_download_permitted();

if ( $show_downloads ) {
	wc_get_template(
		'order/order-downloads.php',
		array(
			'downloads'  => $downloads,
			'show_title' => true,
		)
	);
}
?>
<section class="woocommerce-order-details">
	<?php do_action( 'woocommerce_order_details_before_order_table', $order ); ?>

	<h2 class="woocommerce-order-details__title"><?php esc_html_e( 'Quote details', 'woocommerce-quote' ); ?></h2>

	<table class="woocommerce-table woocommerce-table--order-details shop_table order_details">

		<thead>
			<tr>
				<th class="woocommerce-table__product-name product-name"><?php esc_html_e( 'Product', 'woocommerce-quote' ); ?></th>
				<?php if($has_been_accepted): ?>
				<th class="woocommerce-table__product-table product-total"><?php esc_html_e( 'Total', 'woocommerce-quote' ); ?></th>
				<?php endif; ?>
			</tr>
		</thead>

		<tbody>
			<?php
			do_action( 'woocommerce_order_details_before_order_table_items', $order );

			foreach ( $order_items as $item_id => $item ) 
			{
				$product = $item->get_product();
				?>
				<tr class="<?php echo esc_attr( apply_filters( 'woocommerce_order_item_class', 'woocommerce-table__line-item order_item', $item, $order ) ); ?>">

				<td class="woocommerce-table__product-name product-name">
					<?php
					$is_visible        = $product && $product->is_visible();
					$product_permalink = apply_filters( 'woocommerce_order_item_permalink', $is_visible ? $product->get_permalink( $item ) : '', $item, $order );

					echo wp_kses_post( apply_filters( 'woocommerce_order_item_name', $product_permalink ? sprintf( '<a href="%s">%s</a>', $product_permalink, $item->get_name() ) : $item->get_name(), $item, $is_visible ) );

					$qty          = $item->get_quantity();
					$refunded_qty = $order->get_qty_refunded_for_item( $item_id );

					if ( $refunded_qty ) {
						$qty_display = '<del>' . esc_html( $qty ) . '</del> <ins>' . esc_html( $qty - ( $refunded_qty * -1 ) ) . '</ins>';
					} else {
						$qty_display = esc_html( $qty );
					}

					echo apply_filters( 'woocommerce_order_item_quantity_html', ' <strong class="product-quantity">' . sprintf( '&times;&nbsp;%s', $qty_display ) . '</strong>', $item ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped

					do_action( 'woocommerce_order_item_meta_start', $item_id, $item, $order, false );

					wc_display_item_meta( $item ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped

					do_action( 'woocommerce_order_item_meta_end', $item_id, $item, $order, false );
					?>
				</td>
				<?php if($has_been_accepted): ?>
				<td class="woocommerce-table__product-total product-total">
					<?php echo $order->get_formatted_line_subtotal( $item ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
				</td>
				<?php endif; ?>
			</tr>

			<?php if ( $show_purchase_note && $purchase_note ) : ?>

			<tr class="woocommerce-table__product-purchase-note product-purchase-note">

				<td colspan="2"><?php echo wpautop( do_shortcode( wp_kses_post( $purchase_note ) ) ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?></td>

			</tr>

			<?php endif; 
			}

			do_action( 'woocommerce_order_details_after_order_table_items', $order );
			?>
		</tbody>

		<tfoot>
			<?php if($has_been_accepted)
					foreach ( $order->get_order_item_totals() as $key => $total ) {
						?>
							<tr>
								<th scope="row"><?php echo esc_html( $total['label'] ); ?></th>
								<td><?php echo ( 'payment_method' === $key ) ? esc_html( $total['value'] ) : wp_kses_post( $total['value'] ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?></td>
							</tr>
							<?php
					}
			?>
			<?php if ( $order->get_customer_note() ) : ?>
				<tr>
					<th><?php esc_html_e( 'Note:', 'woocommerce-quote' ); ?></th>
					<td><?php echo wp_kses_post( nl2br( wptexturize( $order->get_customer_note() ) ) ); ?></td>
				</tr>
			<?php endif; ?>
		</tfoot>
	</table>
	<?php 
	$msg = $wcqt_order_model->get_message($order);
	if($msg): ?>
	<div class="wcqt-message-wrapper">
	<?php echo $msg; ?>
	</div>
	<?php endif; 

do_action( 'woocommerce_order_details_after_order_table', $order ); ?>
</section>

 <?php if($order->needs_payment()): ?>
	  <div id="wcqt-action-buttons-container">
		<a id="payment_button" class="woocommerce-button button pay wcqt-action-button" href="<?php echo $order->get_checkout_payment_url()?>"><?php esc_html_e( 'Pay', 'woocommerce-quote' ); ?></a> 
		<a id="cancel_button" class="woocommerce-button button cancel wcqt-action-button" href="<?php echo $current_url."?wcqt_reject=".$order->get_id()."&order_key=".$order->get_order_key()."&_wpnonce=".wp_create_nonce( 'wcqt-view-quote-page-security' ) ?>"><?php esc_html_e( 'Reject quote', 'woocommerce-quote' ); ?></a> 
	  </div>
	  
<?php endif;

do_action( 'woocommerce_after_order_details', $order );

if ( $show_customer_details ) {
	wc_get_template( 'order/order-details-customer.php', array( 'order' => $order ) );
}
