<?php
/**
 * Single variation cart button
 *
 * This template can be overridden by copying it to yourtheme/wcqt/frontend/product-page/variation-add-to-cart-button.php
 *
 * @see https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 7.0.1
 */

defined( 'ABSPATH' ) || exit;

global $product;
?>
<div class="woocommerce-variation-add-to-cart variations_button">
	<?php do_action( 'woocommerce_before_add_to_cart_button' ); ?>

	<?php
	do_action( 'woocommerce_before_add_to_cart_quantity' );

	woocommerce_quantity_input(
		array(
			'min_value'   => apply_filters( 'woocommerce_quantity_input_min', $product->get_min_purchase_quantity(), $product ),
			'max_value'   => apply_filters( 'woocommerce_quantity_input_max', $product->get_max_purchase_quantity(), $product ),
			'input_value' => isset( $_POST['quantity'] ) ? wc_stock_amount( wp_unslash( $_POST['quantity'] ) ) : $product->get_min_purchase_quantity(), // WPCS: CSRF ok, input var ok.
		)
	);

	do_action( 'woocommerce_after_add_to_cart_quantity' );
	?>
	<?php if($original_stock_status =='instock' && ($enable_add_to_cart_button || !$is_quotable)): ?>
	<button type="submit" class="button alt<?php echo esc_attr( wc_wp_theme_get_element_class_name( 'button' ) ? ' ' . wc_wp_theme_get_element_class_name( 'button' ) : '' ); ?>"><?php echo esc_html( $product->single_add_to_cart_text() ); ?></button>
	<div id="wcqt-optional-button-container">
	</div>
	<?php endif;?>
	<?php if($is_quotable && !$quotable_products_can_be_purchased): //In case $quotable_products_can_be_purchased is true, buttons are managed via javascript ?>
	<button type="submit" name="add-to-quote-product-page" value="<?php echo esc_attr( $product->get_id() ); ?>" class="single_add_to_quote_button button alt<?php echo esc_attr( wc_wp_theme_get_element_class_name( 'button' ) ? ' ' . wc_wp_theme_get_element_class_name( 'button' ) : '' ); ?>"><?php echo wcqt_get_value_if_set($options, array('texts', 'add_to_quote_button', $current_lang), esc_html__("Add to quote", 'woocommerce-quote')); ?></button>
	<?php endif;?>
	
	<?php do_action( 'woocommerce_after_add_to_cart_button' ); ?>

	<input type="hidden" name="add-to-cart" value="<?php echo absint( $product->get_id() ); ?>" />
	<input type="hidden" name="product_id" value="<?php echo absint( $product->get_id() ); ?>" />
	<input type="hidden" name="variation_id" class="variation_id" value="0" />
</div>
