<?php 
/**
 * Product table
 *
 * 
 * @version 10
 */
?>
<div class="<?php echo $css_class; ?>" id="wcqt-quote-area-wrapper-<?php echo $quote_area_id; ?>">
	<?php if($quote_creation_result)
		{
			if(!empty($quote_creation_result['messages']))
				{
					foreach($quote_creation_result['messages'] as $data)
					{
						?>
						<div class="wcqt-<?php echo $data['notice_type']; ?>"><?php echo $data['message']; ?></div>
						<?php 
					}
				} 
		}
	?>
	<form class="woocommerce-cart-form wcqt-contact-form" action="<?php echo esc_url( $quote_page_url); ?>" method="post">
		<?php if($recaptcha_options['enable']): ?>
		<script src='https://www.google.com/recaptcha/api.js' async defer ></script>
		<?php endif;?>
		
		<?php wp_nonce_field( 'submit-request', 'wcqt-quote-page-security' ); ?>
		<?php 
		
			foreach((array)$input_fields as $input_field_id => $input_field_data)
				$wcqt_html_model->render_frontend_input_field($input_field_data, $input_field_id);
		?>
		<?php if(!empty($products_to_quote)): ?>
			<?php if($recaptcha_options['enable']): ?>
				<div class="g-recaptcha" data-sitekey="<?php echo $recaptcha_options['site_key']; ?>"></div>
			<?php endif;?>
		<button type="submit" data-id="<?php echo $quote_area_id; ?>" name="wcqt-submit-quote" value="true" class="wcqt-submit-form button <?php echo esc_attr( wc_wp_theme_get_element_class_name( 'button' ) ? ' ' . wc_wp_theme_get_element_class_name( 'button' ) : '' ); ?>" ><?php echo wcqt_get_value_if_set($options, array('texts', 'submit_quote', $curr_lang), esc_html__("Submit quote", 'woocommerce-quote')); ?></button>
		<?php endif; ?>
	</form>
</div>