<?php 
/**
 * Product table
 *
 * 
 * @version 10
 */
?>
<div class="<?php echo $css_class; ?>">
<?php if(empty($products_to_quote)) : 
// Empty quote list ?>
<i><?php echo wcqt_get_value_if_set($options, array('quote_page', 'texts', 'no_table_product_message', $curr_lang), esc_html__("Please select at least one quotable product.", 'woocommerce-quote')); ?></i>
<?php else: 
//Quote table ?>
<form class="woocommerce-cart-form wcqt-quote-product-form" action="<?php echo esc_url( $quote_page_url ); ?>" method="post">
	<table class="shop_table shop_table_responsive cart woocommerce-cart-form__contents wcqt-quote-table" cellspacing="0">
		<thead>
			<tr>
				<th class="product-remove"><span class="screen-reader-text"><?php esc_html_e( 'Remove item', 'woocommerce-quote' ); ?></span></th>
				<th class="product-thumbnail"><span class="screen-reader-text"><?php esc_html_e( 'Thumbnail image', 'woocommerce-quote' ); ?></span></th>
				<th class="product-name"><?php esc_html_e( 'Product', 'woocommerce-quote' ); ?></th>
				<th class="product-quantity"><?php esc_html_e( 'Quantity', 'woocommerce-quote' ); ?></th>
			</tr>
		</thead>
		<tbody>
			
			<?php
			foreach ( $products_to_quote as $unique_id => $product ) 
			{
				$product_id = $product['variation_id'] ? $product['variation_id'] : $product['product_id'];
				$_product   = wc_get_product($product_id);

				if ( $_product && $_product->exists() && $product['quantity'] > 0 ) 
				{
					$product_permalink = $_product->get_permalink( );
					?>
					<tr class="woocommerce-cart-form__cart-item">

						<td class="product-remove">
							<?php
								echo sprintf(
										'<a href="%s" class="remove" aria-label="%s" data-product_id="%s" data-product_sku="%s">&times;</a>',
										esc_url( $quote_page_url."?wcqt-remove=".$unique_id."&wcqt-nonce=".wp_create_nonce('remove-element-from-quote-list', 'wcqt-quote-page' ) ),
										esc_html__( 'Remove this item', 'woocommerce-quote' ),
										esc_attr( $product_id ),
										esc_attr( $_product->get_sku() ));
							?>
						</td>

						<td class="product-thumbnail">
						<?php
						$thumbnail =  $_product->get_image();

						if ( ! $product_permalink ) {
							echo $thumbnail; // PHPCS: XSS ok.
						} else {
							printf( '<a href="%s">%s</a>', esc_url( $product_permalink ), $thumbnail ); // PHPCS: XSS ok.
						}
						?>
						</td>

						<td class="product-name" data-title="<?php esc_attr_e( 'Product', 'woocommerce-quote' ); ?>">
						<?php
						if ( ! $product_permalink ) {
							echo wp_kses_post( $_product->get_name() . '&nbsp;' );
						} else {
							echo wp_kses_post( sprintf( '<a href="%s">%s</a>', esc_url( $product_permalink ), $_product->get_name() ));
						}

						

						// Meta data.
						echo  $wcqt_product_model->get_variation_attributes_names($product_id); // PHPCS: XSS ok.

						
						?>
						</td>

						<td class="product-quantity" data-title="<?php esc_attr_e( 'Quantity', 'woocommerce-quote' ); ?>">
						<?php
						
						$product_quantity = woocommerce_quantity_input(
							array(
								'input_name'   => "wcqt_quote[{$unique_id}][quantity]",
								'input_value'  => $product['quantity'],
								'min_value'    => 0,
								'product_name' => $_product->get_name(),
							),
							$_product,
							false
						);

						echo wcqt_get_value_if_set($options, array('general', 'sold_individually'), "false") == "true" && $_product->get_sold_individually() ? 1 : $product_quantity;
						?>
						</td>

						
					</tr>
					<?php
				}
			}
			?>

			<tr class="actions-row">
				<td colspan="6" class="actions">

					<button type="submit" class="button<?php echo esc_attr( wc_wp_theme_get_element_class_name( 'button' ) ? ' ' . wc_wp_theme_get_element_class_name( 'button' ) : '' ); ?>" name="update_cart" value="<?php esc_attr_e( 'Update quantity', 'woocommerce-quote' ); ?>"><?php esc_html_e( 'Update quantity', 'woocommerce-quote' ); ?></button>

					<?php wp_nonce_field( 'update-quote-list', 'wcqt-quote-page-security' ); ?>
				</td>
			</tr>

			
		</tbody>
	</table>

</form>
<?php endif; ?>
</div>

