<?php
namespace WCQT\classes\admin;

class SettingsPage
{
	function __construct()
	{
		
	}
	public function render_page()
	{
		global $wcqt_option_model, $wcqt_wpml_model, $wcqt_html_model, $wcqt_product_model, $wcqt_user_model, $wcqt_html_model, $wcqt_page_model;
		
		$langs =  $wcqt_wpml_model->get_langauges_list();
		$available_langs = array();
		foreach($langs as $lang_data)
			$available_langs[] = $lang_data['language_code'];
		
		$security = wp_create_nonce('wcqt_admin_settings_page');
		$request_quote_page_link = admin_url("admin.php?page=woocommerce-quote-settings-page&create_quote_page=");
		$variables = array(
			'confirm_delete_message' => __('Are you sure you want to delete the field?', 'woocommerce-quote'),
			'show_options' => __('Show options', 'woocommerce-quote'),
			'hide_options' => __('Hide options', 'woocommerce-quote'),
			'available_langs' => $available_langs,
			'security' => $security
		);
		
		//Save & Retrieval
		if(wcqt_get_value_if_set($_POST, 'wcqt_options', false) && wp_verify_nonce( wcqt_get_value_if_set($_POST, 'wcqt_security', ""), 'wcqt_admin_settings_page' ))
			$wcqt_option_model->save_options($_POST['wcqt_options']);
		
		if(wcqt_get_value_if_set($_GET, 'create_quote_page', "") == 'yes')
		{
			$wcqt_page_model->create_quote_request_page();
			wp_redirect($request_quote_page_link."no");
		}
		
		$options = $wcqt_option_model->get_options();
		$menu_locations = wp_get_nav_menus();
		
		wp_enqueue_style('magnificpopup', WCQT_PLUGIN_PATH.'/css/vendor/magnificpopup/magnific-popup.css');
		wp_enqueue_style( 'select2.css', WCQT_PLUGIN_PATH.'/css/vendor/select2/select2.min.css' );
		wp_enqueue_style( 'wcqt-admin-common', WCQT_PLUGIN_PATH.'/css/admin/common.css');
		wp_enqueue_style( 'wcqt-admin-toggle', WCQT_PLUGIN_PATH.'/css/com/toggle.css');
		wp_enqueue_style( 'wcqt-admin-table', WCQT_PLUGIN_PATH.'/css/com/table.css');
		wp_enqueue_style( 'wcqt-settings-page', WCQT_PLUGIN_PATH.'/css/admin/settings-page.css');
		wp_enqueue_style('datetime-picker', WCQT_PLUGIN_PATH.'/css/vendor/datetimepicker/default.css'); 
		wp_enqueue_style('datetime-picker-date', WCQT_PLUGIN_PATH.'/css/vendor/datetimepicker/default.date.css'); 
		wp_enqueue_style('datetime-picker-time', WCQT_PLUGIN_PATH.'/css/vendor/datetimepicker/default.time.css'); 
		 
		
		wp_register_script( 'wcqt-settings-page', WCQT_PLUGIN_PATH.'/js/admin/settings-page.js', array('jquery') );	
		
		wp_enqueue_script( 'wp-tinymce');	
		wp_enqueue_script( 'selectWoo' );
		wp_enqueue_script( 'datetime-picker', WCQT_PLUGIN_PATH.'/js/vendor/datetimepicker/picker.js', array('jquery'));	
		wp_enqueue_script( 'datetime-picker-date', WCQT_PLUGIN_PATH.'/js/vendor/datetimepicker/picker.date.js', array('jquery'));	
		wp_enqueue_script( 'datetime-picker-time', WCQT_PLUGIN_PATH.'/js/vendor/datetimepicker/picker.time.js', array('jquery'));	
		wp_enqueue_script( 'magnificpopup', WCQT_PLUGIN_PATH.'/js/vendor/magnificpopup/jquery.magnific-popup.min.js', array('jquery'));	
		wp_enqueue_script( 'wcqt-autocomplete-product-and-categories', WCQT_PLUGIN_PATH.'/js/admin/product-categories-autocomplete.js', array('jquery'),false,false );		

		
		wp_localize_script( 'wcqt-settings-page', 'wcqt', $variables );			
		wp_enqueue_script( 'wcqt-settings-page');	
		
		if (wcqt_get_value_if_set($_GET, 'create_quote_page', "") == 'no'): ?>
			<div class="notice notice-success is-dismissible">
				 <p><?php esc_html_e('Quote request page successfully created!', 'woocommerce-quote'); ?></p>
			</div>
		<?php endif; ?>
		
		<?php if ($_SERVER['REQUEST_METHOD'] == 'POST'): ?>
			<div class="notice notice-success is-dismissible">
				 <p><?php esc_html_e('Saved successfully!', 'woocommerce-quote'); ?></p>
			</div>
		<?php endif; ?>
			
		<div class="wrap white-box" id="wcqt-options-container">
			
			<form action="<?php echo  admin_url("admin.php?page=woocommerce-quote-settings-page"); ?>" method="post" >
				<input type="hidden" name="wcqt_security" value="<?php echo $security; ?>"/>
				
				<h2 class="wcqt_section_title wcqt_no_margin_top"><?php esc_attr_e('General', 'woocommerce-quote'); ?></h2>
				
				<h3><?php esc_html_e('Exclusion list', 'woocommerce-file-approval');?></h3>
				<div class="wcqt_option_group wcqt_half">
					<p><strong><?php esc_html_e("NOTE:", 'woocommerce-quote');?></strong> <?php esc_html_e("If no products and categories are selected, all products will considered as excluded/included (according the Exclusion policy setting).", 'woocommerce-quote');?> </p>
					<label class="wcqt_input_label"><?php esc_html_e('Product selection', 'woocommerce-quote');?></label>
					<p><?php esc_html_e("Select which products will be excluded for quote requests.", 'woocommerce-quote');?> </p>
					<label><?php esc_html_e('Select product', 'woocommerce-files-upload');?></label>
					<select class="js-data-products-ajax wcqt_select2"   name="wcqt_options[exclusion][products][]" multiple="multiple"> 
					<?php 
						$selected_products = wcqt_get_value_if_set($options, array('exclusion', 'products'), array());
						foreach( $selected_products as $product_id)
							{
								echo '<option value="'.$product_id.'" selected="selected" >'.$wcqt_product_model->get_product_name($product_id).'</option>';
							}
						?>
					</select>
					
					<label><?php esc_html_e('Select category', 'woocommerce-files-upload');?></label>
					<select class="js-data-product-categories-ajax wcqt_select2" name="wcqt_options[exclusion][categories][]"  multiple="multiple" > 
							<?php 
								$selected_categories = wcqt_get_value_if_set($options, array('exclusion', 'categories'), array());
								foreach( $selected_categories as $category_id)
									{
										echo '<option value="'.$category_id.'" selected="selected" >'.$wcqt_product_model->get_product_category_name($category_id).'</option>';
									}
								?>
					</select>
					<label class="wcqt_input_label"><?php esc_html_e("Exclude sub-categories", 'woocommerce-quote');?> </label>
					<p><?php esc_html_e("When selecting a category, the plugin will also consider products belonging to its subcategories. You can check this option to consider only the selected categories.", 'woocommerce-quote');?></p>
					<label class="switch"> 
						<input type="checkbox"  id="" name="wcqt_options[exclusion][exclude_sub_categories]" value="true" <?php checked(wcqt_get_value_if_set($options, array('exclusion', 'exclude_sub_categories'), false), "true"); ?> ></input>
						<span class="slider"></span>
					</label>
					<label class="wcqt_input_label"><?php esc_html_e("Exclusion policy", 'woocommerce-quote');?> </label>
					<select name="wcqt_options[exclusion][policy]">
						<option value="include" <?php selected(wcqt_get_value_if_set($options, array('exclusion', 'policy'), "include"), "include"); ?>><?php esc_html_e("The selected products are the ones for which can be asked a quote", 'woocommerce-quote');?></option>
						<option value="exclude" <?php selected(wcqt_get_value_if_set($options, array('exclusion', 'policy'), "include"), "exclude"); ?>><?php esc_html_e("Exclude the selected products from quoting", 'woocommerce-quote');?></option>
					</select>
					
								
				</div>
				<div class="wcqt_option_group wcqt_half">
					<label class="wcqt_input_label"><?php esc_html_e("Select roles", 'woocommerce-quote');?> </label>
					<p class="section_description"><?php wcqt_html_escape_allowing_special_tags(__('<strong>Leave unselected to allow quote requests from any user role.</strong> Select which user roles can ask for a quote.', 'woocommerce-files-upload'));?></p>
							<label style="font-weight:normal;">
								<input type="checkbox" <?php checked(wcqt_get_value_if_set($options, array('roles', "not_logged"), false)); ?> name="wcqt_options[roles][not_logged]" value="1"><?php esc_html_e("Not logged / Guests", 'woocommerce-quote');?>
							</label>
					<?php foreach($wcqt_user_model->get_all_user_roles() as $role_code => $role_name): ?>
							<label style="font-weight:normal;">
								<input type="checkbox" <?php checked(wcqt_get_value_if_set($options, array('roles', $role_code), false)); ?> name="wcqt_options[roles][<?php echo $role_code; ?>]" value="1"><?php echo $role_name['name'] ?>
							</label>
					<?php endforeach; ?>
				</div>
				<h3><?php esc_html_e('Products', 'woocommerce-file-approval');?></h3>
				<div class="wcqt_option_group wcqt_half">
					<label class="wcqt_input_label"><?php esc_html_e("Hide quotable products from the store to not allowed users", 'woocommerce-quote');?> </label>
					<p><?php esc_html_e("Products for which can be asked a quote, won't be displayed to the user roles that cannot ask for a quote. By default, not allowed customers can buy items at their regular price.", 'woocommerce-quote');?></p>
					<label class="switch">
						<input type="checkbox"  id="" name="wcqt_options[general][hide_quotable_products]" value="true" <?php checked(wcqt_get_value_if_set($options, array('general', 'hide_quotable_products'), false), "true"); ?> ></input>
						<span class="slider"></span>
					</label>
					<label class="wcqt_input_label"><?php esc_html_e("Show prices", 'woocommerce-quote');?> </label>
					<p><?php esc_html_e("Quotable product prices by default are hidden. Use this option to make them visible.", 'woocommerce-quote');?></p>
					<label class="switch">
						<input type="checkbox"  id="" name="wcqt_options[general][show_prices]" value="true" <?php checked(wcqt_get_value_if_set($options, array('general', 'show_prices'), "false"), "true"); ?> ></input>
						<span class="slider"></span>
					</label>
					
					<label class="wcqt_input_label"><?php esc_html_e("Show add to cart button for quotable products", 'woocommerce-quote');?> </label>
					<p><?php wcqt_html_escape_allowing_special_tags(__("The customer will be able to add quotable products to the cart. <strong>Note</strong> in this way, even if the Hide price option has been enabled, prices will be visible on the cart and checkout pages.", 'woocommerce-quote'));?></p>
					<label class="switch">
						<input type="checkbox"  id="" name="wcqt_options[general][show_add_to_cart_button]" value="true" <?php checked(wcqt_get_value_if_set($options, array('general', 'show_add_to_cart_button'), "false"), "true"); ?> ></input>
						<span class="slider"></span>
					</label>
					
					<label class="wcqt_input_label"><?php esc_html_e("Disable quantity selection for the products that are sold individually", 'woocommerce-quote');?> </label>
					<p><?php wcqt_html_escape_allowing_special_tags(__("For products sold individually, the quotable quantity won't be editable.", 'woocommerce-quote'));?></p>
					<label class="switch">
						<input type="checkbox"  id="" name="wcqt_options[general][sold_individually]" value="true" <?php checked(wcqt_get_value_if_set($options, array('general', 'sold_individually'), "false"), "true"); ?> ></input>
						<span class="slider"></span>
					</label>
				</div>
			
				<h2 class="wcqt_section_title wcqt_no_margin_top"><?php esc_html_e('Google reCAPTCHA', 'woocommerce-quote'); ?></h2>
				<div class="wcqt_option_group wcqt_one_third">
					<label class="wcqt_input_label"><?php esc_html_e("Enable reCAPTCHA V2", 'woocommerce-quote');?> </label>
					<?php $recaptcha_instruction_url = WCQT_PLUGIN_PATH."/img/recaptcha_v2_instructions.jpg"; ?>
					<p><?php echo sprintf(wcqt_html_escape_allowing_special_tags(__("Please visiting the following <a target='_blank' href='https://www.google.com/recaptcha/admin'>URL</a> to register a site and secret keys. Here you find the <strong><a target='_blank' href='%s'>instruction on how to create</a></strong>.", 'woocommerce-quote'), false), $recaptcha_instruction_url);?></p>
					<label class="switch">
						<input type="checkbox"  id="" name="wcqt_options[recaptcha][enable]" value="true" <?php checked(wcqt_get_value_if_set($options, array('recaptcha', 'enable'), false), "true"); ?> ></input>
						<span class="slider"></span>
					</label>					
				</div>
				<div class="wcqt_option_group wcqt_one_third">
					<label class="wcqt_input_label"><?php esc_html_e("Site key", 'woocommerce-quote');?> </label>
					<p><?php wcqt_html_escape_allowing_special_tags(__("Please use the instructions reported on the enable option to get a site key.", 'woocommerce-quote'));  ?></p>
					<input type="text" class="input-text" value="<?php esc_attr_e(wcqt_get_value_if_set($options, array('recaptcha', 'site_key'), "")); ?>" name="wcqt_options[recaptcha][site_key]" placeholder="<?php esc_attr_e("Site key", 'woocommerce-quote'); ?>"></input>
				</div>
				<div class="wcqt_option_group wcqt_one_third">
					<label class="wcqt_input_label"><?php esc_html_e("Secret key", 'woocommerce-quote');?> </label>
					<p><?php wcqt_html_escape_allowing_special_tags(__("Please use the instructions reported on the enable option to get a site secret.", 'woocommerce-quote'));  ?></p>
					<input type="text" class="input-text" value="<?php esc_attr_e(wcqt_get_value_if_set($options, array('recaptcha', 'secret_key'), "")); ?>" name="wcqt_options[recaptcha][secret_key]" placeholder="<?php esc_attr_e("Secret key", 'woocommerce-quote'); ?>"></input>
				</div>
				
				<h2 class="wcqt_section_title wcqt_no_margin_top"><?php esc_html_e('Expire & approval management', 'woocommerce-quote'); ?></h2>
				<div class="wcqt_option_group wcqt_half">
					<label class="wcqt_input_label required"><?php esc_html_e("Automatic exprire", 'woocommerce-quote');?> </label>
					<p><?php wcqt_html_escape_allowing_special_tags(__("The <strong>Accepted quotes</strong> (other statuses, like On hold won't be considered) will automatically expire after the following amount of time if not paid by the customer after the <strong>date the quote has been placed</strong>. <strong>Leave 0 to ignore</strong>.", 'woocommerce-quote'));  ?></p>
					<input type="number" min="0" step="1" name="wcqt_options[expire_approval][expire][value]" required="required" value="<?php echo wcqt_get_value_if_set($options, array('expire_approval',  'expire', 'value'), 0 ); ?>"></input>
					<select name="wcqt_options[expire_approval][expire][type]">
						<option value="hours" <?php checked(wcqt_get_value_if_set($options, array('expire_approval', 'expire', 'type'), "hours"), "hours"); ?>><?php esc_html_e("Hours", 'woocommerce-quote');?></option>
						<option value="days" <?php checked(wcqt_get_value_if_set($options, array('expire_approval', 'expire', 'type'), "hours"), "days"); ?>><?php esc_html_e("Days", 'woocommerce-quote');?></option>
					</select>
				</div>
				<div class="wcqt_option_group wcqt_half">
					<label class="wcqt_input_label required"><?php esc_html_e("Automatic approval", 'woocommerce-quote');?> </label>
					<p><?php wcqt_html_escape_allowing_special_tags(__("The <strong>New quotes</strong> (other statuses, like On hold won't be considered) will automatically be approved by the after the following amount of time after the <strong>date the quote has been placed</strong>. <strong>Leave 0 to ignore</strong>.", 'woocommerce-quote'));  ?></p>
					<input type="number" min="0" step="1" name="wcqt_options[expire_approval][approval][value]" required="required" value="<?php echo wcqt_get_value_if_set($options, array('expire_approval',  'approval', 'value'), 0 ); ?>"></input>
					<select name="wcqt_options[expire_approval][expire][type]">
						<option value="hours" <?php checked(wcqt_get_value_if_set($options, array('expire_approval', 'approval', 'type'), "hours"), "hours"); ?>><?php esc_html_e("Hours", 'woocommerce-quote');?></option>
						<option value="days" <?php checked(wcqt_get_value_if_set($options, array('expire_approval', 'approval', 'type'), "hours"), "days"); ?>><?php esc_html_e("Days", 'woocommerce-quote');?></option>
					</select>
				</div>
				<div class="wcqt_option_group wcqt_half">
					<label class="wcqt_input_label required"><?php esc_html_e("Expiring notification time", 'woocommerce-quote');?> </label>
					<p><?php wcqt_html_escape_allowing_special_tags(__("Set how long before the expiration date the notification will be sent. Notification will be sent only for quotes marked as Accepted. <strong>Leave 0 to send no notification</strong>.", 'woocommerce-quote'));  ?></p>
					<input type="number" min="0" step="1" name="wcqt_options[expire_time_notification][approval][value]" required="required" value="<?php echo wcqt_get_value_if_set($options, array('expire_time_notification',  'approval', 'value'), 0 ); ?>"></input>
					<select name="wcqt_options[expire_time_notification][expire][type]">
						<option value="hours" <?php checked(wcqt_get_value_if_set($options, array('expire_time_notification', 'approval', 'type'), "hours"), "hours"); ?>><?php esc_html_e("Hours", 'woocommerce-quote');?></option>
						<option value="days" <?php checked(wcqt_get_value_if_set($options, array('expire_time_notification', 'approval', 'type'), "hours"), "days"); ?>><?php esc_html_e("Days", 'woocommerce-quote');?></option>
					</select>
				</div>
				
				<h2 class="wcqt_section_title wcqt_no_margin_top"><?php esc_html_e('Email notifications', 'woocommerce-quote'); ?></h2>
				<div class="wcqt_option_group wcqt_half">
					<label class="wcqt_input_label"><?php esc_html_e("Disable admin notifications", 'woocommerce-quote');?> </label>
					<p><?php esc_html_e("Disable email notifications sent to the admin.", 'woocommerce-quote');?></p>
					<label class="switch">
						<input type="checkbox"  id="" name="wcqt_options[email][disable_customer_notification]" value="true" <?php checked(wcqt_get_value_if_set($options, array('email', 'disable_customer_notification'), false), "true"); ?> ></input>
						<span class="slider"></span>
					</label>					
				</div>
				<div class="wcqt_option_group wcqt_half">
					<label class="wcqt_input_label"><?php esc_html_e("Disable customer notifications", 'woocommerce-quote');?> </label>
					<p><?php esc_html_e("Disable email notifications sent to the customers.", 'woocommerce-quote');?></p>
					<label class="switch">
						<input type="checkbox"  id="" name="wcqt_options[email][disable_admin_notification]" value="true" <?php checked(wcqt_get_value_if_set($options, array('email', 'disable_admin_notification'), false), "true"); ?> ></input>
						<span class="slider"></span>
					</label>					
				</div>
				<div class="wcqt_option_group wcqt_half">
						<label><?php esc_html_e('"From" name', 'woocommerce-order-approval');?></label>
						<p><?php echo sprintf(esc_html__("If left empty, the From name used in the email will be the site name: %s.", 'woocommerce-order-approval'), get_bloginfo('name'));?> </p>
						<input type="text" placeholder="<?php echo get_bloginfo('name'); ?>" class="wcqt-text-input" name="wcqt_options[email][from_name]" value="<?php esc_attr_e(wcqt_get_value_if_set($options, array('email', 'from_name'), "")); ?>">	
				</div>
				<div class="wcqt_option_group wcqt_half">
					<label><?php esc_html_e('"From" email address', 'woocommerce-order-approval');?></label>
					<p><?php echo sprintf(wp_kses(__("If left empty, it will be used a generic noreply address.<br><br><strong>NOTE:</strong> some installation <strong>doesn't allow</strong> to modify the from email address for security reasons, so this option might be ineffective.", 'woocommerce-order-approval'), array('strong'=> array(), 'br'=>array())), get_bloginfo('name'));?> </p>
					<input type="text" placeholder="noreply@yourdomain.com" class="wcqt-text-input" name="wcqt_options[email][from_email]" value="<?php esc_attr_e(wcqt_get_value_if_set($options, array('email', 'from_email'), "")); ?>">	
				</div>
				<div class="wcqt_option_group wcqt_full">
					<label class="wcqt_input_label"><?php esc_html_e("Default recipient override", 'woocommerce-quote');?> </label>
					<p><?php esc_html_e("By default notifications are sent to the admin email address set through the WooCommerce -> Settings -> Email area. Using this option you can define custom recipients. You can also define multiple recipients, for example: admin@domain.com, admin2,@domain.com. ", 'woocommerce-quote');?></p>
					<input type="text" class="input-text" value="<?php echo wcqt_get_value_if_set($options, array('email', 'recipient'), ""); ?>" name="wcqt_options[email][recipient]" placeholder="<?php esc_attr_e("Example of multiple recipients: admin@domain.com, admin2,@domain.com", 'woocommerce-quote'); ?>"></input>					
				</div>
				
				<h2 class="wcqt_section_title wcqt_no_margin_top"><?php esc_html_e('Quote page & menu link', 'woocommerce-quote'); ?></h2>
				<div class="wcqt_option_group wcqt_half">
					
					<label class="wcqt_input_label"><?php esc_html_e("'Request a quote' page selection", 'woocommerce-quote');?> </label>
					<p><?php wcqt_html_escape_allowing_special_tags(__("Select which page must be use to display the quote table. It must contain the <strong>[wcqt_request_quote]</strong> shortcode.", 'woocommerce-quote'));  ?></p>
					<select name="wcqt_options[general][quote_page_id]">
					<?php foreach($wcqt_page_model->get_pages_list() as $page_obj): ?>
						<option value="<?php echo $page_obj->ID; ?>" <?php selected(wcqt_get_value_if_set($options, array('general', "quote_page_id"), ""), $page_obj->ID); ?> ><?php echo $page_obj->post_title; ?></option>
					<?php endforeach;?>
					</select>
					<?php 	$request_quote_page_link .= "yes";
							wcqt_html_escape_allowing_special_tags(sprintf(__("or <a href='%s'>Automatically create a page and set is a the Quote request page</a>", 'woocommerce-quote'),$request_quote_page_link));?>
					
				</div>
				<div class="wcqt_option_group wcqt_half">
				<p><?php _e("Quotes page menu link can be Automatically rendered in any menu.", 'woocommerce-quote');?></p>
							
						<?php 
							$menu_locations_without_translation = array();
							foreach($menu_locations as $location_name => $location_id)
							{
								$menu_data = wp_get_nav_menu_object($location_id);
								$menu_term_id = $wcqt_wpml_model->get_original_id($menu_data->term_id, 'nav_menu');
								$data = get_term($menu_term_id);
								$menu_locations_without_translation[$menu_term_id] = $data->name; 
							}
							
							foreach($menu_locations_without_translation as $menu_term_id => $menu_name):
								$selected_before = wcqt_get_value_if_set($options, array('quote_menu','position', $menu_term_id, 'before'), false) ? " checked='checked' " : " ";
								$selected_after = wcqt_get_value_if_set($options, array('quote_menu', 'position', $menu_term_id, 'after'), false) ? " checked='checked' " : " ";
								
								?>
								<div class="wcqt_checkbox_container">
									<input type="checkbox" name="wcqt_options[quote_menu][position][<?php echo $menu_term_id; ?>][before]" <?php echo $selected_before; ?> class="wcqt_option_checbox_field" value="true"><?php echo $menu_name." ".__('- Before other items', 'woocommerce-quote'); ?></input>
								</div>	
								<div class="wcqt_checkbox_container">
									<input type="checkbox" name="wcqt_options[quote_menu][position][<?php echo $menu_term_id; ?>][after]" <?php echo $selected_after; ?> class="wcqt_option_checbox_field" value="true"><?php echo $menu_name." ".__('- After other items', 'woocommerce-quote'); ?></input>
								</div>
						<?php endforeach; ?>
				</div>	
				
				<div class="wcqt_option_group wcqt_half">
					<label class="wcqt_input_label"><?php esc_html_e("Quote page layout", 'woocommerce-quote');?> </label>
					<select name="wcqt_options[quote_page][layout]">
						<option value="left" <?php selected(wcqt_get_value_if_set($options, array('quote_page', "layout"), "left"), "left"); ?>><?php esc_html_e("Contact form on left, Products table on right", 'woocommerce-quote');?></option>
						<option value="right" <?php selected(wcqt_get_value_if_set($options, array('quote_page', "layout"), "left"), "right"); ?>><?php esc_html_e("Contact form on right, Products table on left", 'woocommerce-quote');?></option>
						<option value="top" <?php selected(wcqt_get_value_if_set($options, array('quote_page', "layout"), "left"), "top"); ?>><?php esc_html_e("Contact form on top, Products table on bottom", 'woocommerce-quote');?></option>
						<option value="bottom" <?php selected(wcqt_get_value_if_set($options, array('quote_page', "layout"), "left"), "bottom"); ?>><?php esc_html_e("Contact form on bottom, Products table on top", 'woocommerce-quote');?></option>
					</select>
				</div>
				<div class="wcqt_option_group wcqt_half">
					<label class="wcqt_input_label"><?php esc_html_e("Hide menu if quote basket is empty", 'woocommerce-quote');?> </label>
					<p><?php wcqt_html_escape_allowing_special_tags(__("The quote menu won't be displayed if no product has been added to the quote cart.", 'woocommerce-quote'));?></p>
					<label class="switch">
						<input type="checkbox"  id="" name="wcqt_options[quote_page][hide_menu_if_no_product_on_cart]" value="true" <?php checked(wcqt_get_value_if_set($options, array('quote_page', 'hide_menu_if_no_product_on_cart'), "false"), "true"); ?> ></input>
						<span class="slider"></span>
					</label>
				</div>
				<div class="wcqt_option_group wcqt_half">
					<label class="wcqt_input_label required"><?php esc_html_e("Menu title text", 'woocommerce-quote');?> </label>
					<p><?php wcqt_html_escape_allowing_special_tags(__("Set the text displayed on the menu quote page link. <strong>NOTE:</strong> you can use the special <strong>%d</strong> placeholder to display the number of items currently on the quote list.", 'woocommerce-quote'));  ?></p>
					<?php foreach($langs as $language_code => $lang_data): ?>
						<?php if($lang_data['country_flag_url'] != "none"): ?>
							<br/><img src=<?php echo $lang_data['country_flag_url']; ?> /> <?php echo $lang_data['default_locale']; ?><br/>
						<?php endif; ?>
						<input type="text" required="required" class="input-text" value="<?php esc_attr_e(wcqt_get_value_if_set($options, array('quote_menu', 'title', $lang_data['language_code']), "")); ?>" name="wcqt_options[quote_menu][title][<?php echo  $lang_data['language_code']; ?>]" placeholder="<?php esc_attr_e("%d items in quote", 'woocommerce-quote'); ?>"></input>
					<?php endforeach; ?>
					
				</div>
				
				<div class="wcqt_option_group wcqt_half">
					<label class="wcqt_input_label required"><?php esc_html_e("Empty quote list message", 'woocommerce-quote');?> </label>
					<p><?php wcqt_html_escape_allowing_special_tags(__("Message displayed instead of the quote table in case no quotable product has been selected.", 'woocommerce-quote'));  ?></p>
					<?php foreach($langs as $language_code => $lang_data): ?>
						<?php if($lang_data['country_flag_url'] != "none"): ?>
							<br/><img src=<?php echo $lang_data['country_flag_url']; ?> /> <?php echo $lang_data['default_locale']; ?><br/>
						<?php endif; ?>
						<input type="text" required="required" class="input-text" value="<?php esc_attr_e(wcqt_get_value_if_set($options, array('quote_page', 'texts', 'no_table_product_message', $lang_data['language_code']), esc_html__("Please select at least one quotable product.", 'woocommerce-quote'))); ?>" name="wcqt_options[quote_page][texts][no_table_product_message][<?php echo  $lang_data['language_code']; ?>]" placeholder="<?php esc_attr_e("Please select at least one quotable product.", 'woocommerce-quote'); ?>"></input>
					<?php endforeach; ?>
					
				</div>
				
				<div class="wcqt_option_group wcqt_half">
					<label class="wcqt_input_label required"><?php esc_html_e("Successfully submitted message", 'woocommerce-quote');?> </label>
					<p><?php wcqt_html_escape_allowing_special_tags(__("Message displayed when a quote is successfully submitted.", 'woocommerce-quote'));  ?></p>
					<?php foreach($langs as $language_code => $lang_data): ?>
						<?php if($lang_data['country_flag_url'] != "none"): ?>
							<br/><img src=<?php echo $lang_data['country_flag_url']; ?> /> <?php echo $lang_data['default_locale']; ?><br/>
						<?php endif; ?>
						<input type="text" required="required" class="input-text" value="<?php esc_attr_e(wcqt_get_value_if_set($options, array('quote_page', 'texts', 'successfully_submitted', $lang_data['language_code']), esc_html__("Quote successfully submitted!", 'woocommerce-quote'))); ?>" name="wcqt_options[quote_page][texts][successfully_submitted][<?php echo  $lang_data['language_code']; ?>]" placeholder="<?php esc_attr_e("Quote successfully submitted!", 'woocommerce-quote'); ?>"></input>
					<?php endforeach; ?>
					
				</div>
				
				<!-- No need, the submit button is not displayed in case of empty list. So no message can be eventually displayed
				<div class="wcqt_option_group wcqt_half">
					<label class="wcqt_input_label required"><?php esc_html_e("No product on table error message", 'woocommerce-quote');?> </label>
					<p><?php wcqt_html_escape_allowing_special_tags(__("Message displayed when a quote with no product is submitted", 'woocommerce-quote'));  ?></p>
					<?php foreach($langs as $language_code => $lang_data): ?>
						<?php if($lang_data['country_flag_url'] != "none"): ?>
							<br/><img src=<?php echo $lang_data['country_flag_url']; ?> /> <?php echo $lang_data['default_locale']; ?><br/>
						<?php endif; ?>
						<input type="text" required="required" class="input-text" value="<?php esc_attr_e(wcqt_get_value_if_set($options, array('quote_page', 'texts', 'no_product_error', $lang_data['language_code']), esc_html_e("Please select at least one product to quote.", 'woocommerce-quote'))); ?>" name="wcqt_options[quote_page][texts][no_product_error][<?php echo  $lang_data['language_code']; ?>]" placeholder="<?php esc_attr_e("Please select at least one product to quote.", 'woocommerce-quote'); ?>"></input>
					<?php endforeach; ?>
					
				</div> -->
				
				<h2 class="wcqt_section_title wcqt_no_margin_top"><?php esc_html_e('Shop page', 'woocommerce-quote'); ?></h2>
				<div class="wcqt_option_group wcqt_half">
					<label class="wcqt_input_label required"><?php esc_html_e("Added to quote list notice message", 'woocommerce-quote');?> </label>
					<p><?php wcqt_html_escape_allowing_special_tags(__("This is the text displayed in the notice after a product has been added to the quote list. Use the special %s placeholder to print the product name.", 'woocommerce-quote'));  ?></p>
					<?php foreach($langs as $language_code => $lang_data): ?>
						<?php if($lang_data['country_flag_url'] != "none"): ?>
							<br/><img src=<?php echo $lang_data['country_flag_url']; ?> /> <?php echo $lang_data['default_locale']; ?><br/>
						<?php endif; ?>
						<input type="text" required="required" class="input-text" value="<?php esc_attr_e(wcqt_get_value_if_set($options, array('shop_page', 'texts', 'added_to_list', $lang_data['language_code']), esc_html__('%s added to quote list', 'woocommerce-quote'))); ?>" name="wcqt_options[shop_page][texts][added_to_list][<?php echo  $lang_data['language_code']; ?>]" placeholder="<?php esc_attr_e('%s added to quote list', 'woocommerce-quote'); ?>"></input>
					<?php endforeach; ?>
					
				</div>
				<!-- <div class="wcqt_option_group wcqt_half">
					<label class="wcqt_input_label required"><?php esc_html_e("View quote button", 'woocommerce-quote');?> </label>
					<p><?php wcqt_html_escape_allowing_special_tags(__("This is the text displayed instead of the Add to quote button after the product has been added to the quote list.", 'woocommerce-quote'));  ?></p>
					<?php foreach($langs as $language_code => $lang_data): ?>
						<?php if($lang_data['country_flag_url'] != "none"): ?>
							<br/><img src=<?php echo $lang_data['country_flag_url']; ?> /> <?php echo $lang_data['default_locale']; ?><br/>
						<?php endif; ?>
						<input type="text" required="required" class="input-text" value="<?php esc_attr_e(wcqt_get_value_if_set($options, array('shop_page', 'texts', 'view_quote_button', $lang_data['language_code']), esc_html__('View quote', 'woocommerce-quote'))); ?>" name="wcqt_options[shop_page][texts][view_quote_button][<?php echo  $lang_data['language_code']; ?>]" placeholder="<?php esc_attr_e('View quote', 'woocommerce-quote'); ?>"></input>
					<?php endforeach; ?>
					
				</div> -->
				
				<h2 class="wcqt_section_title wcqt_no_margin_top"><?php esc_html_e('My Account page', 'woocommerce-quote'); ?></h2>
				<div class="wcqt_option_group wcqt_one_third">
				<label class="wcqt_input_label required"><?php esc_html_e("Quotes menu element text", 'woocommerce-quote');?> </label>
				<p><?php wcqt_html_escape_allowing_special_tags(__("Set the text displayed on the My account menu.", 'woocommerce-quote'));  ?></p>
					<?php foreach($langs as $language_code => $lang_data): ?>
						<?php if($lang_data['country_flag_url'] != "none"): ?>
							<br/><img src=<?php echo $lang_data['country_flag_url']; ?> /> <?php echo $lang_data['default_locale']; ?><br/>
						<?php endif; ?>
						<input type="text" required="required" class="input-text" value="<?php esc_attr_e(wcqt_get_value_if_set($options, array('my_account', 'menu_title', $lang_data['language_code']), esc_html__("Quotes", 'woocommerce-quote'))); ?>" name="wcqt_options[my_account][menu_title][<?php echo  $lang_data['language_code']; ?>]" placeholder="<?php esc_attr_e("Quotes", 'woocommerce-quote'); ?>"></input>
					<?php endforeach; ?>
				</div>
				<div class="wcqt_option_group wcqt_one_third">
					<label class="wcqt_input_label required"><?php esc_html_e("Quotes list page endpoint", 'woocommerce-quote');?> </label>
					<p><?php wcqt_html_escape_allowing_special_tags(__("Set the URL endpoint used for the Quotes list page", 'woocommerce-quote'));  ?></p>
					<input type="text" required="required" class="input-text" value="<?php esc_attr_e(wcqt_get_value_if_set($options, array('my_account', 'endpoint', 'quotes_list'), "quotes")); ?>" name="wcqt_options[my_account][endpoint][quotes_list]" placeholder="<?php esc_attr_e("quotes", 'woocommerce-quote'); ?>"></input>
				</div>
				<div class="wcqt_option_group wcqt_one_third">
					<label class="wcqt_input_label required"><?php esc_html_e("Quote details page endpoint", 'woocommerce-quote');?> </label>
					<p><?php wcqt_html_escape_allowing_special_tags(__("Set the URL endpoint used for the Quote details page", 'woocommerce-quote'));  ?></p>
					<input type="text" required="required" class="input-text" value="<?php esc_attr_e(wcqt_get_value_if_set($options, array('my_account', 'endpoint', 'quote_details'), "view-quote")); ?>" name="wcqt_options[my_account][endpoint][quote_details]" placeholder="<?php esc_attr_e("view-quote", 'woocommerce-quote'); ?>"></input>
				</div>
				
				<h2 class="wcqt_section_title wcqt_no_margin_top"><?php esc_html_e('Texts', 'woocommerce-quote'); ?></h2>
				<div class="wcqt_option_group wcqt_half">
				<label class="wcqt_input_label required"><?php esc_html_e("Add to quote button", 'woocommerce-quote');?> </label>
				<p><?php wcqt_html_escape_allowing_special_tags(__("Add to quote button text displayed on the shop and product pages.", 'woocommerce-quote'));  ?></p>
					<?php foreach($langs as $language_code => $lang_data): ?>
						<?php if($lang_data['country_flag_url'] != "none"): ?>
							<br/><img src=<?php echo $lang_data['country_flag_url']; ?> /> <?php echo $lang_data['default_locale']; ?><br/>
						<?php endif; ?>
						<input type="text" required="required" class="input-text" value="<?php esc_attr_e(wcqt_get_value_if_set($options, array('texts', 'add_to_quote_button', $lang_data['language_code']), esc_html__("Add to quote", 'woocommerce-quote'))); ?>" name="wcqt_options[texts][add_to_quote_button][<?php echo  $lang_data['language_code']; ?>]" placeholder="<?php esc_attr_e("Add to quote", 'woocommerce-quote'); ?>"></input>
					<?php endforeach; ?>
				</div>
				<div class="wcqt_option_group wcqt_half">
				<label class="wcqt_input_label required"><?php esc_html_e("Submit quote button", 'woocommerce-quote');?> </label>
				<p><?php wcqt_html_escape_allowing_special_tags(__("Submit Quote displayed in the Quote request page", 'woocommerce-quote'));  ?></p>
					<?php foreach($langs as $language_code => $lang_data): ?>
						<?php if($lang_data['country_flag_url'] != "none"): ?>
							<br/><img src=<?php echo $lang_data['country_flag_url']; ?> /> <?php echo $lang_data['default_locale']; ?><br/>
						<?php endif; ?>
						<input type="text" required="required" class="input-text" value="<?php esc_attr_e(wcqt_get_value_if_set($options, array('texts', 'submit_quote', $lang_data['language_code']), esc_html__("Submit quote", 'woocommerce-quote'))); ?>" name="wcqt_options[texts][submit_quote][<?php echo  $lang_data['language_code']; ?>]" placeholder="<?php esc_attr_e("Submit quote", 'woocommerce-quote'); ?>"></input>
					<?php endforeach; ?>
				</div>
				
				
				<p class="submit">
					<input type="submit" class="button-primary wcqt_save_button disable_during_animation" value="<?php esc_attr_e('Save', 'woocommerce-quote'); ?>" /> 
				</p>
			</form>
			
			
		</div>
		<?php
	}
}
?>