<?php 
namespace WCQT\classes\com;

class Country
{
	public function __construct()
	{
		add_action('wp_ajax_wcqt_load_state_by_country_id', array(&$this, 'ajax_load_state_by_country_id'));
		add_action('wp_ajax_nopriv_wcqt_load_state_by_country_id', array(&$this, 'ajax_load_state_by_country_id'));
	}
	function ajax_load_state_by_country_id()
	{
		$country_id = isset($_POST['country_id']) ? $_POST['country_id'] : "";
		$unique_id = isset($_POST['unique_id']) ? $_POST['unique_id'] : "";
		$default_value = wcqt_get_value_if_set($_POST, 'autofill_state', "") != "" ? $_POST['autofill_state'] : null;
		if($country_id != "")
			$this->render_state_select_html_by_country($country_id, $unique_id, $default_value);
		wp_die();
	}
	function render_state_select_html_by_country($country_id, $unique_id, $default_val = null, $use_wide_row = false)
	{
		$field_html_name = "wcqt-form[{$unique_id}][state]";
		$field_html_id = "wcqt-state-selector-".$unique_id;
		$countries_obj   = new \WC_Countries();
		$states = $countries_obj->get_states( $country_id ); //paramenter -> GB, IT ... is the "value" selected in the $countries select box
		$label_data =  $countries_obj->get_country_locale();
		
		$custom_attributes = array();
		
		if ( is_array( $states ) && empty( $states ) ) //Like Germany, it doesn't have a states/provinces
		{
			woocommerce_form_field($field_html_name, array(
							'type'       => 'hidden',
							'class'      => $use_wide_row ? array( 'form-row-wide' ) : array( 'form-row-last' ),
							'label'      => wcqt_get_value_if_set($label_data, array($country_id, 'state', 'label'), ""),
							'label_class' => array( 'wcqt_form_label' ),
							'value'    => $states,
							'id' => $field_html_id
							));
		}
		elseif(is_array($states)) //Ex.: Italy
		{
			$reordered_states = array();
			$reordered_states[""] = esc_html__('Select one','wp-user-extra-fields');
			foreach($states as $state_code => $state_name)
				$reordered_states[$state_code] = $state_name;
			
			$required = isset($label_data[$country_id]['state']['required']) ? $label_data[$country_id]['state']['required'] : false;
			$custom_attributes['required'] = $required; 
			woocommerce_form_field($field_html_name, array(
							'type'       => 'select',
							'required'   => $required,
							'class'      => $use_wide_row ? array( 'form-row-wide', 'select2-container' ) : array( 'form-row-last', 'select2-container' ),
							'label'      => $label_data[$country_id]['state']['label'] ? $label_data[$country_id]['state']['label'] : esc_html__('State','woocommerce-quote'),
							'label_class' => array( 'wcqt_form_label' ),
							'input_class' => array('select2-choice', 'wpuef_state_selector', "wcqt_state_selector"),
							'custom_attributes' =>  $custom_attributes,
							'options'    => $reordered_states,
							'default' => isset($default_val) ? $default_val : "",
							'id' => $field_html_id
							)
			);
		}
		else //$states is false. Ex.: UK
		{
			$required = isset($label_data[$country_id]['state']['required']) ? $label_data[$country_id]['state']['required'] : false;
			$custom_attributes['required'] = $required; 
			woocommerce_form_field($field_html_name, array(
						'type'       => 'text',
						'class'      => $use_wide_row ? array( 'form-row-wide' ) : array( 'form-row-last' ),
						'required'          => $required,
						'input_class' => array('wcmca_input_field'),
						'label'      => $label_data[$country_id]['state']['label'] ? $label_data[$country_id]['state']['label'] : esc_html__('State','woocommerce-quote'),
						'label_class' => array( 'wcqt_form_label' ),
						'custom_attributes' =>  $custom_attributes,
						'default' => isset($default_val) ? $default_val : "",
						'id' => $field_html_id
						)
						);
		}
	}
	function isEU($countrycode)
	{
		global $wcqt_vat_field_model;
		$countries = new \WC_Countries();
		
		$eu_countrycodes =  $countries->get_european_union_countries();
		
		if( !empty($country_to_exclude = $wcqt_vat_field_model->get_all_options('disabled_eu_countries')))
			if(($key = array_search($country_to_exclude, $eu_countrycodes)) !== false) 
				unset($eu_countrycodes[$key]);	
				
		return(in_array($countrycode, $eu_countrycodes));
    }
	public function get_allowed_countries_list($type = 'allowed_countries')
	{
		/*
			type = allowed_countries || shipping_countries || all
		*/
		global $wcqt_vat_field_model;
		$countries = new \WC_Countries();
		$shipping_countries = $countries->get_shipping_countries();
		$eu_countries = $countries->get_european_union_countries();
		$all_countries = $countries->get_countries();
		
		$final_result = array();
		switch($type)
		{
			case "allowed_countries": $final_result =  $countries->get_allowed_countries(); break;
			case "shipping_countries": $final_result = $countries->get_shipping_countries(); break;
			case "all": $final_result = $all_countries = $countries->get_countries(); break;
		}
		return $final_result;
	}
	function get_eu_vat_country_codes()
	{
		$countries = new \WC_Countries();
		return $countries->get_european_union_countries();;
	}
}
?>