<?php 
namespace WCQT\classes\com;

class Email
{
	public function __construct()
	{
		add_filter('init', array($this, 'init'));
	}
	function init()
	{
		global $wcqt_order_model;
		$statuses = $wcqt_order_model->get_notification_statuses();
		
		foreach($statuses as $status)
			add_action( "woocommerce_order_status_{$status}", array( $this, 'trigger' ), 10, 2 );
		
	}
	public function trigger( $order_id, $order = false ) 
	{
		global $wcqt_order_model;
		
		$order = !$order ? wc_get_order( $order_id ) : $order;
		if(!$order)
			return;
		
		$order_status = $order->get_status();
		if(!$wcqt_order_model->notification_can_be_sent($order))
			return;
		
		$email_type = str_replace("wc-", "", $order->get_status());
		
		$this->send($order, $email_type);
	}
	public function trigger_expiring_quote_notification($order_id)
	{
		
		global $wcqt_order_model;
		
		$order = $order_id && !is_object($order_id) ? wc_get_order( $order_id ) : $order_id;
		if(!$order)
			return;
		
		if(!$wcqt_order_model->notification_can_be_sent($order, "expiring-quote"))
			return;
		
		$this->send($order, "expiring-quote");
	}
	public function send($wc_order, $email_type = "expiring-quote", $user_type = null)
	{
		global $wcqt_option_model, $wcqt_order_model, $wcqt_shortcode_model, $wcqt_wpml_model;
		
		$wc_order = isset($wc_order) && is_object($wc_order) ? $wc_order : wc_get_order($wc_order);
		if(!$wc_order)
			return false;
		
		$email_type_to_user_type = array('new-quote' => 'admin', 'expired-quote' => 'customer', 'accepted-quote' => 'customer', 'rejected-quote' => 'customer' , 'rejected-quote-2' => 'admin', 'expiring-quote' => 'customer');
		$user_type = !isset($user_type) ? $email_type_to_user_type[$email_type] : $user_type;
		
		$texts = $wcqt_option_model->get_email_texts(); 
		$options = $wcqt_option_model->get_options();
		
		if(($user_type != 'customer' && wcqt_get_value_if_set($options, array('email', 'disable_admin_notification'), false)) || 
			($user_type == 'customer' && wcqt_get_value_if_set($options, array('email', 'disable_customer_notification'), false)) )
			 return false;
			
		$customer_email = $wc_order->get_billing_email();
		if($user_type == "customer" && $customer_email == "" && $wc_order->get_customer_id())
		{
			$user = get_user_by('ID', $wc_order->get_customer_id() );
			$customer_email = $user && isset($user->user_email) ? $user->user_email : "";
		}
		
		$lang = $user_type == 'customer' ? $wcqt_order_model->get_lang($wc_order) : $wcqt_wpml_model->get_default_language_code();
		$recipients = $user_type == 'customer' ? $customer_email : wcqt_get_value_if_set($options, array('email', 'recipient'), get_option('woocommerce_email_from_address')); 
		$recipients = $user_type != 'customer' &&  $recipients == "" ?  get_option('woocommerce_email_from_address') : $recipients; 
		$from = "";		
		
		if($recipients == "")
			return;
		
		$body_content = wcqt_get_value_if_set($texts, array($user_type, $email_type, 'body', $lang), "");
		$subject = wcqt_get_value_if_set($texts , array($user_type, $email_type, 'subject', $lang), "");
		//1. Replace all shortcodes
		$body_content = $wcqt_shortcode_model->replace_shortcodes_with_order_data($body_content, $wc_order, $user_type);
		$subject = $wcqt_shortcode_model->replace_shortcodes_with_order_data($subject, $wc_order, $user_type);
		
		//attachments management
		$attachments = array();
		
		$mail = WC()->mailer();
		/* Old method
			$message = wcqt_trim_breaks(nl2br(trim($body_content)));
			$message = $mail->wrap_message(get_bloginfo('name'), stripcslashes($message));
		*/
		
		ob_start();
		echo wc_get_template_html(
					"emails/{$email_type}.php", //to override: wooccomerce/emails/{$email_type}.php
					array(
						'order'              => $wc_order,
						'email_heading'      => $wcqt_shortcode_model->replace_shortcodes_with_order_data(wcqt_get_value_if_set($texts , array($user_type, $email_type,'heading', $lang), ""),$wc_order), //head option
						'body_content' 		 => $body_content, //body option
						'sent_to_admin'      => $user_type == 'admin',
						'plain_text'         => false,
						'body_content'		 => $body_content,
						'email'              => '',
					),
					get_theme_file_path().'/woocommerce-quote/',
					WCQT_PLUGIN_ABS_PATH . '/templates/'
					
				);
		$message =  ob_get_contents();
		ob_end_clean();
		
		add_filter('wp_mail_from_name',array(&$this, 'wp_mail_from_name'), 99, 1);
		add_filter('wp_mail_from', array(&$this, 'wp_mail_from'));
		if(wcqt_get_value_if_set($options, array('email', 'from_email'), "") != "" )
			$from .= " From: " . wcqt_get_value_if_set($options, array('email', 'from_email'), get_bloginfo('name')) . "\r\n";
		
		if(!$mail->send( $recipients, $subject, $message, "Content-Type: text/html\r\n".$from , $attachments)) 
			wp_mail( $recipients, $subject, $message, "Content-Type: text/html\r\n".$from , $attachments);
		remove_filter('wp_mail_from_name',array(&$this, 'wp_mail_from_name'));
		remove_filter('wp_mail_from',array(&$this, 'wp_mail_from'));
	}
	
	public function wp_mail_from_name($name) 
	{
		global $wcqt_option_model;
		$options = $wcqt_option_model->get_options();
		return wcqt_get_value_if_set($options, array('email', 'from_name'), get_bloginfo('name'));
	}
	public function wp_mail_from($content_type) 
	{
		global $wcqt_option_model;
		$options = $wcqt_option_model->get_options();
		$server_headers = function_exists('apache_request_headers') ? apache_request_headers() : wcqt_apache_request_headers();
		$domain = isset($server_headers['Host']) ? $server_headers['Host'] : null ;
		if(!isset($domain) && isset($_SERVER['HTTP_HOST']))
			$domain = str_replace("www.", "", $_SERVER['HTTP_HOST'] );
		
		return wcqt_get_value_if_set($options, array('email', 'from_email'), isset($domain) ? 'noprely@'.$domain : $content_type);
	}
}
?>