<?php 
namespace WCQT\classes\com;

class Option
{
	var $options_cache = null;
	var $form_options_cache = null;
	var $email_text_cache = null;
	public function __construct()
	{
		add_action('wp_ajax_wcqt_save_input_field', array($this,'ajax_save_input_field'));
		add_action('wp_ajax_wcqt_delete_input_field', array($this,'ajax_delete_input_field'));
		add_action('wp_ajax_wcqt_update_form_element_indexes', array($this,'ajax_update_form_element_indexes'));
	}
	
	public function ajax_save_input_field()
	{
		$this->input_fields_is_ajax_request = true;
		$posted_data = wcqt_get_value_if_set($_POST, array('wcqt_options', 'input_fields'), array());
		if(wp_verify_nonce( wcqt_get_value_if_set($_POST, 'security', ""), 'wcqt_admin_form_page' ))
		{
			$data = $this->get_form_options();
			foreach($posted_data as $index => $current_data)
			{
				$to_unescape = array("label", "placeholder", "value");
				foreach($to_unescape as $unescape_item_name)
					if(isset($current_data[$unescape_item_name]))
						foreach($current_data[$unescape_item_name] as $lang_code => $item_to_unescape)
							$current_data[$unescape_item_name][$lang_code] = stripslashes($item_to_unescape);
				
				$data[$index] = $current_data;
			}
				
			
			$this->update_option('wcqt_form_options', $data);
		}
		wp_die();
	}
	public function ajax_delete_input_field()
	{
		$this->input_fields_is_ajax_request = true;
		$id = filter_input( INPUT_POST, 'id', FILTER_VALIDATE_INT );
		if(wp_verify_nonce( wcqt_get_value_if_set($_POST, 'security', ""), 'wcqt_admin_form_page' ))
		{
			$data = $this->get_form_options();
			if(isset($data[$id]))
				unset($data[$id]);
			
			$this->update_option('wcqt_form_options', $data);
		}
		wp_die();
	}
	public function ajax_update_form_element_indexes()
	{
		$this->input_fields_is_ajax_request = true;
		$posted_data = wcqt_get_value_if_set($_POST, array('data'), array());
		if(wp_verify_nonce( wcqt_get_value_if_set($_POST, 'security', ""), 'wcqt_admin_form_page' ))
		{
			$old_data = $this->get_form_options();
			$final_data = array();
			foreach($posted_data as $index => $field_id)
			{
				$final_data[$field_id] = $old_data[$field_id];
			}
			$this->update_option('wcqt_form_options', $final_data);
		}
		wp_die();
	}
	public function update_quote_request_page($id)
	{
		$options = $this->get_options();
		if(!isset($options['general']))
			$options['general'] = array();
		
		$options['general']['quote_page_id'] = $id;
		
		$this->update_option('wcqt_options', $options);
	}
	public function save_options($options)
	{
		$this->update_option( 'wcqt_options', $options);
		return $options;
	}
	public function update_option($field_name, $value )
	{
		$this->options_cache = null;
		$this->form_options_cache = null;
		return update_option( $field_name, $value );
	}
	public function get_options($option_name = null, $dafault = null)
	{
		global $wcqt_wpml_model;
		$data = isset($this->options_cache) ? $this->options_cache : get_option('wcqt_options');
		$this->options_cache = $data;
		
		//default values 
		$is_first_run = $data == false || !isset($data);
		if($is_first_run)
		{
			$langs =  $wcqt_wpml_model->get_langauges_list();
			$data = array('quote_menu' => array('title'=> array()));
			foreach($langs as $lang_data)
			{	
				$data['quote_menu']['title'][$lang_data['language_code']] = esc_html__("%d items in quote", 'woocommerce-quote');
			}
				
		}
		
		if($option_name)
		{
			$data = isset($data[$option_name]) ? $data[$option_name] : $default;
		}
		return isset($data) ? $data : array();
	}
	public function get_form_options()
	{
		global $wcqt_wpml_model;
		$allowed_tags = array('br' => array(), 'p' => array(), 'strong' => array(), 'i' => array(), 'a' => array());
		$options = isset($this->form_options_cache) ? $this->form_options_cache : $options = get_option('wcqt_form_options');
		$this->form_options_cache = $options;
		
		//default values 
		$is_first_run = $options == false || !isset($options);
		if($is_first_run)
		{
			$langs =  $wcqt_wpml_model->get_langauges_list();
			
			$options = array(0 => array('type' => "text",     'label'=> array(), 'connects_to' => 'billing_first_name', 'position' => 'first', 'required' => true), //First name
							 1 => array('type' => "text", 	  'label'=> array(), 'connects_to' => 'billing_last_name', 'position' => 'last', 'required' => true), //Last name
							 2 => array('type' => "email", 	  'label'=> array(), 'connects_to' => 'billing_email', 'position' => 'wide', 'required' => true), //Email
							 3 => array('type' => "textarea", 'label'=> array() ,'connects_to' => 'order_note', 'position' => 'wide'), //Note
							 );
			
			foreach($langs as $lang_data)
			{					
				$options[0]['label'][$lang_data['language_code']] = wp_kses(__('First name', 'woocommerce-quote'), $allowed_tags);
				$options[1]['label'][$lang_data['language_code']] = wp_kses(__('Last name', 'woocommerce-quote'), $allowed_tags);
				$options[2]['label'][$lang_data['language_code']] = wp_kses(__('Email', 'woocommerce-quote'), $allowed_tags);
				$options[3]['label'][$lang_data['language_code']] = wp_kses(__('Note', 'woocommerce-quote'), $allowed_tags);
			}
			
		} 
		
		return $options;
	}
	public function get_recaptcha()
	{
		$options = $this->get_options();
		$recaptcha = array();
		$recaptcha['enable'] = wcqt_get_value_if_set($options, array('recaptcha', 'enable'), false) == 'true';
		$recaptcha['secret_key'] = wcqt_get_value_if_set($options, array('recaptcha', 'secret_key'), "");
		$recaptcha['site_key'] = wcqt_get_value_if_set($options, array('recaptcha', 'site_key'), "");
		
		if($recaptcha['secret_key'] == "" || $recaptcha['site_key'] == "")
			$recaptcha['enable'] = false;
		
		return $recaptcha;
	}
	public function get_default_email_texts()
	{
		$allowed_tags = array('br' => array(), 'p' => array(), 'strong' => array(), 'i' => array(), 'a' => array());
		$texts = array();
		$texts['admin']['new-quote']['heading'] = wp_kses(__('New quote', 'woocommerce-quote'), $allowed_tags);
		$texts['admin']['new-quote']['subject'] = wp_kses(__('A new quote (#[order_id]) has been placed!', 'woocommerce-quote'), $allowed_tags);
		$texts['admin']['new-quote']['body'] = __('Go on the <a href="[order_url]">quote page</a> for more details.', 'woocommerce-quote');
		
		$texts['admin']['rejected-quote-2']['heading'] = wp_kses(__('Quote rejected', 'woocommerce-quote'), $allowed_tags);
		$texts['admin']['rejected-quote-2']['subject'] = wp_kses(__('Quote #[order_id] has been rejected', 'woocommerce-quote'), $allowed_tags);
		$texts['admin']['rejected-quote-2']['body'] = __('Go on the <a href="[order_url]">quote page</a> for more details.', 'woocommerce-quote');
			
		$texts['customer']['accepted-quote']['heading'] = wp_kses(__('Quote accepted', 'woocommerce-quote'), $allowed_tags);	
		$texts['customer']['accepted-quote']['subject'] = wp_kses(__('Quote #[order_id] has been accepted!', 'woocommerce-quote'), $allowed_tags);
		$texts['customer']['accepted-quote']['body'] = __('Your quote has been accepted.<br/><br/>Go on the <a href="[order_url]">quote page</a> for more details.', 'woocommerce-quote');
		
		$texts['customer']['new-quote']['heading'] = wp_kses(__('Quote submitted', 'woocommerce-quote'), $allowed_tags);	
		$texts['customer']['new-quote']['subject'] = wp_kses(__('Your quote has been submitted!', 'woocommerce-quote'), $allowed_tags);
		$texts['customer']['new-quote']['body'] = __('Your quote have been submitted we will be in touch soon!<br/><br/>Go on the <a href="[order_url]">quote page</a> for more details.', 'woocommerce-quote');
		
		$texts['customer']['rejected-quote']['heading'] = wp_kses(__('Quote rejected', 'woocommerce-quote'), $allowed_tags);	
		$texts['customer']['rejected-quote']['subject'] = wp_kses(__('Quote#[order_id] has been rejected', 'woocommerce-quote'), $allowed_tags);
		$texts['customer']['rejected-quote']['body'] = __('Your quote has been rejected.<br/><br/>Go on the <a href="[order_url]">quote page</a> for more details.', 'woocommerce-quote');
		
		$texts['customer']['expiring-quote']['heading'] = wp_kses(__('Quote is expiring', 'woocommerce-quote'), $allowed_tags);	
		$texts['customer']['expiring-quote']['subject'] = wp_kses(__('Quote #[order_id] is expiring', 'woocommerce-quote'), $allowed_tags);
		$texts['customer']['expiring-quote']['body'] = __('The Quote #[order_id] is expering on [expiring_date]<br/><br/>Go on the <a href="[order_url]">quote page</a> for more details.', 'woocommerce-quote');
				
		return $texts;
	}
	public function get_email_texts($option_name = null, $default_value = null)
	{
		global  $wcqt_wpml_model;
		$result = null;
		
		//To delete the option: delete_option('wcqt_text_options');
		$options = isset($this->email_text_cache) ? $this->email_text_cache : $options = get_option('wcqt_email_texts');
		$this->email_text_cache = $options;
		$def_lang = $wcqt_wpml_model->get_default_language_code();
		
		//default values 
		$is_first_run = $options == false || !isset($options) || empty($options);
		//debug: $is_first_run = true;
		$options = $is_first_run ? array() : $options;
		if($is_first_run)
		{
			$langs =  $wcqt_wpml_model->get_langauges_list();
			$defaults = $this->get_default_email_texts();
					
			// -- Email message
			$options = array();
			
			$options['admin']['new-quote']['heading'][$def_lang] =  $defaults['admin']['new-quote']['heading'];	
			$options['admin']['new-quote']['subject'][$def_lang] = $defaults['admin']['new-quote']['subject'];
			$options['admin']['new-quote']['body'][$def_lang] = $defaults['admin']['new-quote']['body'];
			
			$options['admin']['rejected-quote-2']['heading'][$def_lang] =  $defaults['admin']['rejected-quote-2']['heading'];	
			$options['admin']['rejected-quote-2']['subject'][$def_lang] = $defaults['admin']['rejected-quote-2']['subject'];
			$options['admin']['rejected-quote-2']['body'][$def_lang] = $defaults['admin']['rejected-quote-2']['body'];
			
			foreach($langs as $lang_data)
			{	
				$options['customer']['new-quote']['heading'][$lang_data['language_code']] =  $defaults['customer']['new-quote']['heading'];			
				$options['customer']['new-quote']['subject'][$lang_data['language_code']] =  $defaults['customer']['new-quote']['subject'];
				$options['customer']['new-quote']['body'][$lang_data['language_code']] = $defaults['customer']['new-quote']['body'];
				
				$options['customer']['accepted-quote']['heading'][$lang_data['language_code']] =  $defaults['customer']['accepted-quote']['heading'];			
				$options['customer']['accepted-quote']['subject'][$lang_data['language_code']] =  $defaults['customer']['accepted-quote']['subject'];
				$options['customer']['accepted-quote']['body'][$lang_data['language_code']] = $defaults['customer']['accepted-quote']['body'];
				
				$options['customer']['rejected-quote']['heading'][$lang_data['language_code']] =  $defaults['customer']['rejected-quote']['heading'];	
				$options['customer']['rejected-quote']['subject'][$lang_data['language_code']] =  $defaults['customer']['rejected-quote']['subject'];
				$options['customer']['rejected-quote']['body'][$lang_data['language_code']] = $defaults['customer']['rejected-quote']['body'];
				
				$options['customer']['expiring-quote']['heading'][$lang_data['language_code']] =  $defaults['customer']['expiring-quote']['heading'];	
				$options['customer']['expiring-quote']['subject'][$lang_data['language_code']] =  $defaults['customer']['expiring-quote']['subject'];
				$options['customer']['expiring-quote']['body'][$lang_data['language_code']] = $defaults['customer']['expiring-quote']['body'];
				
			}
			
			
			
		}
		//end default values
		
		//load values
		if($option_name != null)
		{
			$result = wcqt_get_value_if_set($options, $option_name ,$default_value);
		}
		else 
			$result = $options;
		
		return $result;
	} 
	public function save_email_texts($data) 
	{
		if(isset($data))
			$data = $this->escape_text($data);
		
		$this->email_text_cache = null;
		update_option('wcqt_email_texts', $data);
	}
	private function escape_text($data)
	{
		foreach($data as $index => $content)
		{
			if(is_string($content))
				$data[$index] = stripcslashes($content);
			else if(is_array($content))
				$data[$index] = $this->escape_text($content);
		}
		return $data;
	}
}
?>