<?php 
namespace WCQT\classes\frontend;

class Menu
{
	function __construct()
	{
		//triggered on cart update
		add_filter( 'woocommerce_add_to_cart_fragments', array($this, 'update_quote_page_link' ), 99, 1); //Fragments update
		add_action('wp', array($this, 'on_wp_init')); //init
	}
	public function on_wp_init()
	{
		add_filter( 'wp_get_nav_menu_items', array(&$this, 'add_quote_page_link_to_menu'), 20 , 2 ); //reference: https://www.daggerhart.com/dynamically-add-item-to-wordpress-menus/
		
	}
	function add_quote_page_link_to_menu($items, $menu) 
	{
		if(is_admin())
			return $items;
		
		/*
			object(WP_Term)#4125 (10) {
			  ["term_id"]=>
			  int(8)
			  ["name"]=>
			  string(6) "Menu 1"
			  ["slug"]=>
			  string(6) "menu-1"
			  ["term_group"]=>
			  int(0)
			  ["term_taxonomy_id"]=>
			  int(8)
			  ["taxonomy"]=>
			  string(8) "nav_menu"
			  ["description"]=>
			  string(0) ""
			  ["parent"]=>
			  int(0)
			  ["count"]=>
			  int(7)
			  ["filter"]=>
			  string(3) "raw"
			}
		*/
		
		global $wcqt_option_model, $wcqt_html_model, $wcqt_wpml_model;
		$options = $wcqt_option_model->get_options();
		$target_url = get_page_link(wcqt_get_value_if_set($options, array('general', "quote_page_id"), ""));
		$curr_lang = $wcqt_wpml_model->get_current_language();
		$menu_term_id = $wcqt_wpml_model->get_original_id($menu->term_id, 'nav_menu');
		$position_where_render = array('before' => wcqt_get_value_if_set($options, array('quote_menu', 'position', $menu_term_id, 'before'), false),
									   'after'=> wcqt_get_value_if_set($options, array('quote_menu', 'position', $menu_term_id, 'after'), false));
		
		
		wp_enqueue_style( 'wcqt-quote-menu', WCQT_PLUGIN_PATH.'/css/frontend/quote-menu.css');
		wp_register_script( 'wcqt-quote-menu', WCQT_PLUGIN_PATH.'/js/frontend/quote-menu.js');
		$js_data = array( 
						'ajax_url' => admin_url( 'admin-ajax.php' ) ,
						'quote_page_url' => $target_url,
						'view_quote_button' => wcqt_get_value_if_set($options, array('shop_page', 'texts', 'view_quote_button', $curr_lang), esc_html__('View quote', 'woocommerce-quote'))
					);
		wp_localize_script('wcqt-quote-menu', 'wcqt_menu', $js_data);
		wp_enqueue_script( 'wcqt-quote-menu');
		
		foreach($position_where_render as $position => $render)
		{
			if(!$render)
				continue;
			
			$base_priority = 200+rand(1,20234324);
			
			//First element
			$title = $this->generate_quote_page_link_title();
			if($title == "")
				continue;
			
			$top = $wcqt_html_model->create_custom_nav_menu_item( $title, $target_url, $base_priority );
			
			$result = array();
			$result[] = $top;
			
			
			$items = $wcqt_html_model->merge_menu_arrays($items, $result, $position);
		}
		
		return $items;
	}
	function generate_quote_page_link_title()
	{
		global $wcqt_wpml_model, $wcqt_option_model, $wcqt_session_model;
		$lang = $wcqt_wpml_model->get_current_language();
		$options = $wcqt_option_model->get_options(); 
		$quote_list = $wcqt_session_model->get_quote_list();
		$num_of_items = 0;
		foreach($quote_list as $elment)
			$num_of_items += $elment['quantity'];
		
		if(wcqt_get_value_if_set($options, array('quote_page', 'hide_menu_if_no_product_on_cart'), "false") == "true" && $num_of_items == 0)
			return "";
		
		return '<div class="wcqt-menu"><span class="dashicons dashicons-cart wcqt-dash-quote-menu-icon wcqt-quote-page-link-icon"></span><span class="wcqt-quote-page-link-title">'.sprintf(wcqt_get_value_if_set($options, array('quote_menu', 'title', $lang), esc_html__("%d items in quote", 'woocommerce-quote')),$num_of_items).'</span></div>';
	}
	function update_quote_page_link( $fragments ) 
	{
		global $woocommerce, $wcqt_session_model;
		$quote_list = $wcqt_session_model->get_quote_list();
		ob_start();
		echo $this->generate_quote_page_link_title();
		$fragments['div.wcqt-menu'] = ob_get_clean();
		
		return $fragments;

	}
}
?>