<?php
/*
Plugin Name: WooCommerce Quote
Description: Quote management system.
Author: Lagudi Domenico
Text Domain: woocommerce-quote
Domain Path: /languages/
Version: 7.4
*/


define('WCQT_PLUGIN_PATH', rtrim(plugin_dir_url(__FILE__), "/") ) ;
define('WCQT_PLUGIN_LANG_PATH', basename( dirname( __FILE__ ) ) . '/languages' ) ;
define('WCQT_PLUGIN_ABS_PATH', dirname( __FILE__ ) );

add_action( 'before_woocommerce_init', function() {
	if ( class_exists( \Automattic\WooCommerce\Utilities\FeaturesUtil::class ) ) {
		\Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility( 'custom_order_tables', __FILE__, true );
	}
} );

if ( !defined('WP_CLI') && ( in_array( 'woocommerce/woocommerce.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ||
					   (is_multisite() && array_key_exists( 'woocommerce/woocommerce.php', get_site_option('active_sitewide_plugins') ))
					 )	
	)
{
	$wcqt_id = "44590140";
	$wcqt_name = "WooCommerce Quote";
	$wcqt_activator_slug = "wcqt-activator";
	
	if(isset($_REQUEST ['context']) && $_REQUEST['context'] == 'edit') //rest api
		return;
		
	include 'classes/com/Globals.php';
	require_once('classes/vendor/vanquish/admin/ActivationPage.php');
	
	add_action('init', 'wcqt_init');
	add_action('admin_menu', 'wcqt_init_act');
	if(defined('DOING_AJAX') && DOING_AJAX)
			wcqt_init_act();
	add_action('admin_notices', 'wcqt_admin_notices' );
}
function wcqt_admin_notices()
{
	global $lqt, $wcqt_name, $wcqt_activator_slug;
	if($lqt && (!isset($_GET['page']) || $_GET['page'] != $wcqt_activator_slug))
	{
		 ?>
		<div class="notice notice-success">
			<p><?php wcqt_html_escape_allowing_special_tags(sprintf(__( 'To complete the <span style="color:#96588a; font-weight:bold;">%s</span> plugin activation, you must verify your purchase license. Click <a href="%s">here</a> to verify it.', 'woocommerce-quote' ), $wcqt_name, get_admin_url()."admin.php?page=".$wcqt_activator_slug)); ?></p>
		</div>
		<?php
	}
}
function wcqt_init_act()
{
	global $wcqt_activator_slug, $wcqt_name, $wcqt_id;
	new WCQT\vendor\vanquish\admin\ActivationPage($wcqt_activator_slug, $wcqt_name, 'woocommerce-quote', $wcqt_id, WCQT_PLUGIN_PATH);
}

function wcqt_init()
{
	load_plugin_textdomain('woocommerce-quote', false, basename( dirname( __FILE__ ) ) . '/languages' );
}
function wcqt_eu()
{
	global $wcqt_wpml_model, $wcqt_html_model, $wcqt_option_model, $wcqt_user_model, $wcqt_product_model, $wcqt_order_model, $wcqt_page_model, 
		   $wcqt_session_model, $wcqt_shortcode_model, $wcqt_time_model, $wcqt_input_field_model, $wcqt_country_model, $wcqt_cron_model, $wcqt_email_model;
	
	//com
	require_once('classes/vendor/vanquish/com/Updater.php'); 
	new WCQT\vendor\vanquish\com\Updater(); 
	require_once('classes/com/Cart.php'); 
	new WCQT\classes\com\Cart();
	
	require_once('classes/com/Wpml.php');
	$wcqt_wpml_model = new WCQT\classes\com\Wpml();
	
	require_once('classes/com/HTML.php');
	$wcqt_html_model = new WCQT\classes\com\HTML();
	
	require_once('classes/com/Option.php');
	$wcqt_option_model = new WCQT\classes\com\Option();
	
	require_once('classes/com/User.php');
	$wcqt_user_model = new WCQT\classes\com\User();
	
	require_once('classes/com/Product.php');
	$wcqt_product_model = new WCQT\classes\com\Product();
	
	require_once('classes/com/Order.php');
	$wcqt_order_model = new WCQT\classes\com\Order();
	
	require_once('classes/com/Page.php');
	$wcqt_page_model = new WCQT\classes\com\Page();
	
	require_once('classes/com/Session.php');
	$wcqt_session_model = new WCQT\classes\com\Session();
	
	require_once('classes/com/Time.php');
	$wcqt_time_model = new WCQT\classes\com\Time();
	
	require_once('classes/com/Country.php');
	$wcqt_country_model = new WCQT\classes\com\Country();
	
	require_once('classes/com/InputField.php');
	$wcqt_input_field_model = new WCQT\classes\com\InputField();
	
	require_once('classes/com/Shortcode.php');
	$wcqt_shortcode_model = new WCQT\classes\com\Shortcode();
	
	require_once('classes/com/Cron.php');
	$wcqt_cron_model = new WCQT\classes\com\Cron();
	
	require_once('classes/com/Email.php');
	$wcqt_email_model = new WCQT\classes\com\Email();
	
	//admin 
	require_once('classes/admin/QuoteDetailsPage.php');
	new WCQT\classes\admin\QuoteDetailsPage();
	require_once('classes/admin/OrdersTablePage.php');
	new WCQT\classes\admin\OrdersTablePage();
	require_once('classes/admin/ProductPage.php');
	new WCQT\classes\admin\ProductPage();
	require_once('classes/admin/ProductsTablePage.php');
	new WCQT\classes\admin\ProductsTablePage();
	
	require_once('classes/admin/QuotesTablePage.php');
	require_once('classes/admin/SettingsPage.php');
	require_once('classes/admin/FormPage.php');
	require_once('classes/admin/TextsPage.php');
	require_once('classes/admin/EmailTextsPage.php');

	//frontend
	require_once('classes/frontend/Menu.php'); 
	new WCQT\classes\frontend\Menu();
	
	require_once('classes/frontend/ShopPage.php'); 
	new WCQT\classes\frontend\ShopPage();
	
	require_once('classes/frontend/ProductPage.php'); 
	new WCQT\classes\frontend\ProductPage();

	require_once('classes/frontend/OrderListPage.php'); 
	new WCQT\classes\frontend\OrderListPage();
	
	require_once('classes/frontend/MyAccountPage.php'); 
	new WCQT\classes\frontend\MyAccountPage();
	
	add_action('admin_menu', 'wcqt_init_admin_panel');
}
function wcqt_init_admin_panel()
{
	if(!current_user_can('manage_woocommerce'))
		return;
	
	$place = wcqt_get_free_menu_position(59 , .1);
	$cap = 'manage_woocommerce';
	
	add_menu_page( 'WooCommerce Quote', esc_html__('WooCommerce Quote', 'woocommerce-quote'), $cap, 'wcqt-woocommerce-quote', null,  "dashicons-format-quote" , (string)$place);
	//no need for now add_submenu_page( 'wcqt-woocommerce-quote', esc_html__('WooCommerce Quote - Quotes', 'woocommerce-quote'),  esc_html__('Quotes', 'woocommerce-quote'), $cap, 'woocommerce-quote-quotes-page', 'wcqt_render_admin_page' );
	add_submenu_page( 'wcqt-woocommerce-quote', esc_html__('WooCommerce Quotes - Quotes', 'woocommerce-quote'),  esc_html__('Quotes', 'woocommerce-quote'), $cap, 'woocommerce-quote-quotes-table-page','wcqt_render_admin_page');
	add_submenu_page( 'wcqt-woocommerce-quote', esc_html__('WooCommerce Quote - Settings', 'woocommerce-quote'),  esc_html__('Settings', 'woocommerce-quote'), $cap, 'woocommerce-quote-settings-page', 'wcqt_render_admin_page' );
	add_submenu_page( 'wcqt-woocommerce-quote', esc_html__('WooCommerce Quote - Contact form', 'woocommerce-quote'),  esc_html__('Contact form', 'woocommerce-quote'), $cap, 'woocommerce-quote-form-page', 'wcqt_render_admin_page' );
	add_submenu_page( 'wcqt-woocommerce-quote', esc_html__('WooCommerce Quote - Emails', 'woocommerce-quote'),  esc_html__('Emails', 'woocommerce-quote'), $cap, 'woocommerce-quote-emails-page', 'wcqt_render_admin_page' );
	remove_submenu_page( 'wcqt-woocommerce-quote', 'wcqt-woocommerce-quote'); 
}
function wcqt_render_admin_page()
{
	if(!isset($_REQUEST['page']))
		return;
	
	switch($_REQUEST['page'])
	{
		case 'woocommerce-quote-settings-page':
			$settings_page = new WCQT\classes\admin\SettingsPage();
			$settings_page->render_page();
		break;
		case 'woocommerce-quote-form-page':
			$settings_page = new WCQT\classes\admin\FormPage();
			$settings_page->render_page();
		break;
		case 'woocommerce-quote-quotes-page':
			$settings_page = new WCQT\classes\admin\QuotesPage();
			$settings_page->render_page();
		break;
		case 'woocommerce-quote-texts-page':
			$settings_page = new WCQT\classes\admin\TextsPage();
			$settings_page->render_page();
		break;
		case 'woocommerce-quote-quotes-table-page':
			$settings_page = new WCQT\classes\admin\QuotesTablePage();
			$settings_page->render_page();
		break;
		case 'woocommerce-quote-emails-page':
			$settings_page = new WCQT\classes\admin\EmailTextsPage();
			$settings_page->render_page();
		break;
	}
}
function wcqt_get_free_menu_position($start, $increment = 0.1)
{
	foreach ($GLOBALS['menu'] as $key => $menu) {
		$menus_positions[] = $key;
	}
	
	if (!in_array($start, $menus_positions)) return $start;

	/* the position is already reserved find the closet one */
	while (in_array($start, $menus_positions)) {
		$start += $increment;
	}
	return $start;
}